/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.acm.ACMSplitInStreamDefinitionFilter;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioStream;

class ACMAudioStreamToSplitList
extends ArrayList<ACMSplitInStreamDefinitionFilter> {
    ACMAudioStreamToSplitList() {
    }

    Optional<ACMSplitInStreamDefinitionFilter> findFirst(InputAudioStream item) {
        return this.findAll(item).findFirst();
    }

    Stream<ACMSplitInStreamDefinitionFilter> findAll(InputAudioStream item) {
        BiPredicate<ACMSplitInStreamDefinitionFilter, InputAudioStream> condition = this.containCondition();
        return this.stream().filter(t -> condition.test((ACMSplitInStreamDefinitionFilter)t, item));
    }

    protected BiPredicate<ACMSplitInStreamDefinitionFilter, InputAudioStream> containCondition() {
        return (split, intStream) -> split.getInputAudioStream().equals(intStream);
    }

    Optional<ACMSplitInStreamDefinitionFilter.SplittedOut> search(OutputAudioStream.OutputAudioChannel outputAudioChannel) {
        return this.findAll(outputAudioChannel.getInputAudioStream()).filter(splitIn -> {
            boolean contain = splitIn.getSplittedOut().containsKey(outputAudioChannel.getChInIndex());
            if (!contain) {
                return false;
            }
            ACMSplitInStreamDefinitionFilter.SplittedOut split = splitIn.getSplittedOut().get(outputAudioChannel.getChInIndex());
            return split.getOutputAudioChannel().equals(outputAudioChannel);
        }).map(splitIn -> splitIn.getSplittedOut().get(outputAudioChannel.getChInIndex())).findFirst();
    }
}

