/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.about;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.commons.IORuntimeException;
import tv.hd3g.fflauncher.FFbase;
import tv.hd3g.fflauncher.about.FFAboutCodec;
import tv.hd3g.fflauncher.about.FFAboutDevice;
import tv.hd3g.fflauncher.about.FFAboutFilter;
import tv.hd3g.fflauncher.about.FFAboutFormat;
import tv.hd3g.fflauncher.about.FFAboutPixelFormat;
import tv.hd3g.fflauncher.about.FFAboutProtocols;
import tv.hd3g.fflauncher.about.FFAboutVersion;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.Exec;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.tool.ExecutableTool;

public class FFAbout {
    private static final String CUVID = "cuvid";
    private static final Logger log = LogManager.getLogger();
    private final String execName;
    private final ExecutableFinder executableFinder;
    private final ScheduledExecutorService maxExecTimeScheduler;
    private FFAboutVersion version;
    private List<FFAboutCodec> codecs;
    private List<FFAboutFormat> formats;
    private List<FFAboutDevice> devices;
    private Set<String> bitStreamFilters;
    private FFAboutProtocols protocols;
    private List<FFAboutFilter> filters;
    private List<FFAboutPixelFormat> pixelsFormats;
    private Set<String> hardwareAccelerationMethods;
    public static final Map<String, Integer> sample_formats;

    public FFAbout(String execName, ExecutableFinder executableFinder, ScheduledExecutorService maxExecTimeScheduler) {
        this.execName = Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.executableFinder = Objects.requireNonNull(executableFinder, "\"executableFinder\" can't to be null");
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
    }

    private CapturedStdOutErrTextRetention internalRun(String bulkParameters) {
        try {
            FFbase referer = new FFbase(this.execName, new Parameters(bulkParameters));
            referer.setMaxExecTimeScheduler(this.maxExecTimeScheduler);
            return new Exec((ExecutableTool)referer, this.executableFinder).runWaitGetText(null);
        }
        catch (InvalidExecution e) {
            if (log.isDebugEnabled()) {
                log.debug("Can't execute {}, it return: {}", (Object)this.execName, (Object)e.getStdErr());
            }
            throw e;
        }
        catch (IOException e) {
            throw new IORuntimeException("Can't execute " + this.execName, e);
        }
    }

    public synchronized FFAboutVersion getVersion() {
        if (this.version == null) {
            this.version = new FFAboutVersion(this.internalRun("-loglevel quiet -version").getStdouterrLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.version;
    }

    public synchronized List<FFAboutCodec> getCodecs() {
        if (this.codecs == null) {
            this.codecs = FFAboutCodec.parse(this.internalRun("-codecs").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.codecs;
    }

    public synchronized List<FFAboutFormat> getFormats() {
        if (this.formats == null) {
            this.formats = FFAboutFormat.parseFormats(this.internalRun("-formats").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.formats;
    }

    public synchronized List<FFAboutDevice> getDevices() {
        if (this.devices == null) {
            this.devices = FFAboutDevice.parseDevices(this.internalRun("-devices").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.devices;
    }

    static Set<String> parseBSFS(Stream<String> lines) {
        return lines.map(String::trim).filter(line -> !line.toLowerCase().startsWith("Bitstream filters:".toLowerCase())).collect(Collectors.toSet());
    }

    public synchronized Set<String> getBitStreamFilters() {
        if (this.bitStreamFilters == null) {
            this.bitStreamFilters = FFAbout.parseBSFS(this.internalRun("-bsfs").getStdoutLines(false).map(String::trim));
        }
        return this.bitStreamFilters;
    }

    public synchronized FFAboutProtocols getProtocols() {
        if (this.protocols == null) {
            this.protocols = new FFAboutProtocols(this.internalRun("-protocols").getStdouterrLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.protocols;
    }

    public synchronized List<FFAboutFilter> getFilters() {
        if (this.filters == null) {
            this.filters = FFAboutFilter.parseFilters(this.internalRun("-filters").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.filters;
    }

    public synchronized List<FFAboutPixelFormat> getPixelFormats() {
        if (this.pixelsFormats == null) {
            this.pixelsFormats = FFAboutPixelFormat.parsePixelsFormats(this.internalRun("-pix_fmts").getStdoutLines(false).map(String::trim).collect(Collectors.toUnmodifiableList()));
        }
        return this.pixelsFormats;
    }

    static Set<String> parseHWAccelerationMethods(Stream<String> lines) {
        return lines.map(String::trim).filter(line -> !line.toLowerCase().startsWith("Hardware acceleration methods:".toLowerCase())).collect(Collectors.toSet());
    }

    public synchronized Set<String> getAvailableHWAccelerationMethods() {
        if (this.hardwareAccelerationMethods == null) {
            this.hardwareAccelerationMethods = FFAbout.parseHWAccelerationMethods(this.internalRun("-hwaccels").getStdoutLines(false).map(String::trim));
        }
        return this.hardwareAccelerationMethods;
    }

    public boolean isCoderIsAvaliable(String codec_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.name.equalsIgnoreCase(codec_name) && codec.encodingSupported);
    }

    public boolean isDecoderIsAvaliable(String codec_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.name.equalsIgnoreCase(codec_name) && codec.decodingSupported);
    }

    public boolean isFromFormatIsAvaliable(String demuxer_name) {
        return this.getFormats().stream().anyMatch(format -> format.name.equalsIgnoreCase(demuxer_name) && format.demuxing);
    }

    public boolean isToFormatIsAvaliable(String muxer_name) {
        return this.getFormats().stream().anyMatch(format -> format.name.equalsIgnoreCase(muxer_name) && format.muxing);
    }

    public boolean isFilterIsAvaliable(String filter_name) {
        return this.getFilters().stream().anyMatch(filter -> filter.getTag().equalsIgnoreCase(filter_name));
    }

    public boolean isCoderEngineIsAvaliable(String engine_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.encodingSupported && codec.encoders.contains(engine_name));
    }

    public boolean isDecoderEngineIsAvaliable(String engine_name) {
        return this.getCodecs().stream().anyMatch(codec -> codec.decodingSupported && codec.decoders.contains(engine_name));
    }

    public boolean isNVToolkitIsAvaliable() {
        if (!this.getAvailableHWAccelerationMethods().contains("cuda")) {
            log.debug("(NVIDIA) Cuda is not available in hardware acceleration methods");
            return false;
        }
        if (!this.getAvailableHWAccelerationMethods().contains(CUVID)) {
            log.debug("(NVIDIA) Cuvid is not available in hardware acceleration methods");
            return false;
        }
        List allNvRelatedCodecs = this.getCodecs().stream().filter(c -> !c.decoders.isEmpty() || !c.encoders.isEmpty()).flatMap(c -> Stream.concat(c.decoders.stream(), c.encoders.stream())).distinct().filter(c -> c.contains("nvenc") || c.contains(CUVID)).collect(Collectors.toList());
        if (allNvRelatedCodecs.stream().noneMatch(c -> c.contains("nvenc"))) {
            log.debug("(NVIDIA) nvenc is not available in codec list");
            return false;
        }
        if (allNvRelatedCodecs.stream().noneMatch(c -> c.contains(CUVID))) {
            log.debug("(NVIDIA) cuvid is not available in codec list");
            return false;
        }
        return true;
    }

    public boolean isHardwareNVScalerFilterIsAvaliable() {
        return this.getVersion().configuration.contains("libnpp");
    }

    static {
        HashMap<String, Integer> sf = new HashMap<String, Integer>();
        sf.put("u8", 8);
        sf.put("s16", 16);
        sf.put("s32", 32);
        sf.put("flt", 32);
        sf.put("dbl", 64);
        sf.put("u8p", 8);
        sf.put("s16p", 16);
        sf.put("s32p", 32);
        sf.put("fltp", 32);
        sf.put("dblp", 64);
        sf.put("s64", 64);
        sf.put("s64p", 64);
        sample_formats = Collections.unmodifiableMap(sf);
    }
}

