/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import tv.hd3g.fflauncher.filtering.lavfimtd.NumberParserTraits;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;
import tv.hd3g.fflauncher.resultparser.Stereo;

public class Ebur128StrErrFilterEvent
implements NumberParserTraits {
    private final float t;
    private final float target;
    private final float m;
    private final float s;
    private final float i;
    private final float lra;
    private final Stereo<Float> spk;
    private final Stereo<Float> ftpk;
    private final Stereo<Float> tpk;

    public Ebur128StrErrFilterEvent(String lineValue) {
        HashMap<String, String> content = new HashMap<String, String>();
        List<String> dataItems = MediaAnalyser.splitter(lineValue, ':');
        String key = null;
        String value = null;
        for (int pos = 0; pos < dataItems.size(); ++pos) {
            String entry = dataItems.get(pos);
            if (pos == 0) {
                key = entry;
                continue;
            }
            if (pos + 1 == dataItems.size()) {
                content.put(Objects.requireNonNull(key), entry.trim());
                continue;
            }
            int lastSpacePos = entry.lastIndexOf(" ");
            value = entry.substring(0, lastSpacePos);
            content.put(Objects.requireNonNull(key), value.trim());
            key = entry.substring(lastSpacePos + 1);
        }
        this.t = this.extractValue((String)content.get("t"));
        this.target = this.extractValue((String)content.get("TARGET"));
        this.m = this.extractValue((String)content.get("M"));
        this.s = this.extractValue((String)content.get("S"));
        this.i = this.extractValue((String)content.get("I"));
        this.lra = this.extractValue((String)content.get("LRA"));
        this.spk = this.extractValues((String)content.get("SPK"));
        this.ftpk = this.extractValues((String)content.get("FTPK"));
        this.tpk = this.extractValues((String)content.get("TPK"));
    }

    private float extractValue(String rawValue) {
        if (rawValue == null || rawValue.equalsIgnoreCase("nan")) {
            return Float.NEGATIVE_INFINITY;
        }
        return this.parseFloat(MediaAnalyser.splitter(rawValue, ' ', 2).get(0));
    }

    private Stereo<Float> extractValues(String rawValue) {
        if (rawValue == null) {
            return new Stereo<Float>(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY));
        }
        List<String> items = MediaAnalyser.splitter(rawValue, ' ');
        float l = items.get(0).equalsIgnoreCase("nan") ? Float.NEGATIVE_INFINITY : this.parseFloat(items.get(0));
        float r = items.get(1).equalsIgnoreCase("nan") ? Float.NEGATIVE_INFINITY : this.parseFloat(items.get(1));
        return new Stereo<Float>(Float.valueOf(l), Float.valueOf(r));
    }

    public float getT() {
        return this.t;
    }

    public float getTarget() {
        return this.target;
    }

    public float getM() {
        return this.m;
    }

    public float getS() {
        return this.s;
    }

    public float getI() {
        return this.i;
    }

    public float getLra() {
        return this.lra;
    }

    public Stereo<Float> getSpk() {
        return this.spk;
    }

    public Stereo<Float> getFtpk() {
        return this.ftpk;
    }

    public Stereo<Float> getTpk() {
        return this.tpk;
    }

    public String toString() {
        return "Ebur128StrErrFilterEvent(t=" + this.getT() + ", target=" + this.getTarget() + ", m=" + this.getM() + ", s=" + this.getS() + ", i=" + this.getI() + ", lra=" + this.getLra() + ", spk=" + this.getSpk() + ", ftpk=" + this.getFtpk() + ", tpk=" + this.getTpk() + ")";
    }
}

