/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFprobe;
import tv.hd3g.fflauncher.enums.FFLogLevel;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.ExecutableToolRunning;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class ProbeMedia {
    private final String execName;
    private final ExecutableFinder executableFinder;
    private final ScheduledExecutorService maxExecTimeScheduler;

    public ProbeMedia(ExecutableFinder executableFinder, ScheduledExecutorService maxExecTimeScheduler) {
        this("ffprobe", executableFinder, maxExecTimeScheduler);
    }

    public ProbeMedia(String execName, ExecutableFinder executableFinder, ScheduledExecutorService maxExecTimeScheduler) {
        this.execName = Objects.requireNonNull(execName);
        this.executableFinder = Objects.requireNonNull(executableFinder);
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler);
    }

    private FFprobe internal() {
        Parameters parameters = new Parameters();
        FFprobe ffprobe = new FFprobe(this.execName, parameters);
        ffprobe.setPrintFormat(FFprobe.FFPrintFormat.XML).setShowStreams().setShowFormat().setShowChapters().isHidebanner();
        ffprobe.setMaxExecTimeScheduler(this.maxExecTimeScheduler);
        ffprobe.setLogLevel(FFLogLevel.ERROR, false, false);
        ffprobe.setFilterForLinesEventsToDisplay(l -> l.isStdErr() && ffprobe.filterOutErrorLines().test(l.getLine()));
        return ffprobe;
    }

    private FFprobeJAXB execute(FFprobe ffprobe) {
        ExecutableToolRunning rtFFprobe = ffprobe.execute(this.executableFinder);
        CapturedStdOutErrTextRetention textRetention = rtFFprobe.checkExecutionGetText();
        String stdOut = textRetention.getStdout(false, System.lineSeparator());
        return FFprobeJAXB.load((String)stdOut);
    }

    public FFprobeJAXB doAnalysing(String source) {
        FFprobe ffprobe = this.internal();
        ffprobe.addSimpleInputSource(source, new String[0]);
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        return this.execute(ffprobe);
    }

    public FFprobeJAXB doAnalysing(File source) {
        FFprobe ffprobe = this.internal();
        ffprobe.addSimpleInputSource(source, new String[0]);
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        return this.execute(ffprobe);
    }
}

