/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFprobe;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeResultSAX;
import tv.hd3g.fflauncher.recipes.BaseAnalyserSession;
import tv.hd3g.fflauncher.recipes.ContainerAnalyser;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserResult;
import tv.hd3g.processlauncher.ExecutableToolRunning;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class ContainerAnalyserSession
extends BaseAnalyserSession {
    private static final Logger log = LoggerFactory.getLogger(ContainerAnalyserSession.class);
    private final ContainerAnalyser containerAnalyser;
    private final String source;
    private final File sourceFile;

    ContainerAnalyserSession(ContainerAnalyser containerAnalyser, String source, File sourceFile) {
        this.containerAnalyser = containerAnalyser;
        if (source == null && sourceFile == null) {
            throw new IllegalArgumentException("No source for ffmpeg");
        }
        this.source = source;
        this.sourceFile = sourceFile;
    }

    private FFprobe prepareFFprobe() {
        FFprobe ffprobe = this.containerAnalyser.createFFprobe();
        ffprobe.setHidebanner();
        ffprobe.setShowFrames();
        ffprobe.setShowPackets();
        ffprobe.setPrintFormat(FFprobe.FFPrintFormat.XML);
        if (this.source != null) {
            ffprobe.addSimpleInputSource(this.source, new String[0]);
        } else {
            ffprobe.addSimpleInputSource(this.sourceFile, new String[0]);
        }
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        this.applyMaxExecTime(ffprobe);
        return ffprobe;
    }

    public ContainerAnalyserResult process() {
        FFprobe ffprobe = this.prepareFFprobe();
        FFprobeResultSAX parser = new FFprobeResultSAX();
        ExecutableToolRunning runTool = ffprobe.executeDirectStdout(this.containerAnalyser.getExecutableFinder(), parser);
        log.debug("Start {}", (Object)runTool.getLifecyle().getLauncher().getFullCommandLine());
        runTool.waitForEndAndCheckExecution();
        return parser.getResult(this);
    }

    public static ContainerAnalyserResult importFromOffline(InputStream ffprobeStdOut) {
        FFprobeResultSAX parser = new FFprobeResultSAX();
        parser.onProcessStart(ffprobeStdOut, null);
        parser.onClose(null);
        return parser.getResult(null);
    }

    public void extract(Consumer<String> sysOut) {
        FFprobe ffprobe = this.prepareFFprobe();
        CircularFifoQueue stdErrLinesBucket = new CircularFifoQueue(10);
        ProcesslauncherLifecycle processLifecycle = ffprobe.execute(this.containerAnalyser.getExecutableFinder(), lineEntry -> {
            String line = lineEntry.getLine();
            log.trace("Line: {}", (Object)line);
            if (!lineEntry.isStdErr()) {
                sysOut.accept(line);
            } else {
                stdErrLinesBucket.add((Object)line.trim());
            }
        });
        log.debug("Start {}", (Object)processLifecycle.getLauncher().getFullCommandLine());
        processLifecycle.waitForEnd();
        boolean execOk = processLifecycle.isCorrectlyDone();
        if (!execOk) {
            String stdErr = stdErrLinesBucket.stream().collect(Collectors.joining("|"));
            throw new InvalidExecution(processLifecycle, stdErr);
        }
    }

    public ContainerAnalyser getContainerAnalyser() {
        return this.containerAnalyser;
    }

    public String getSource() {
        return this.source;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

