/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.util.List;
import java.util.TreeSet;
import java.util.function.Consumer;
import tv.hd3g.fflauncher.filtering.AbstractFilterMetadata;
import tv.hd3g.fflauncher.filtering.AudioFilterAMetadata;
import tv.hd3g.fflauncher.filtering.AudioFilterAPhasemeter;
import tv.hd3g.fflauncher.filtering.AudioFilterAstats;
import tv.hd3g.fflauncher.filtering.AudioFilterEbur128;
import tv.hd3g.fflauncher.filtering.AudioFilterSilencedetect;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.AudioFilterVolumedetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlackdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlockdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlurdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterCropdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterFreezedetect;
import tv.hd3g.fflauncher.filtering.VideoFilterIdet;
import tv.hd3g.fflauncher.filtering.VideoFilterMEstimate;
import tv.hd3g.fflauncher.filtering.VideoFilterMetadata;
import tv.hd3g.fflauncher.filtering.VideoFilterSiti;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;

public interface AddFiltersTraits {
    public boolean addFilter(VideoFilterSupplier var1);

    public boolean addFilter(AudioFilterSupplier var1);

    default public boolean addFilterPhasemeter(Consumer<AudioFilterAPhasemeter> filterifPresent) {
        return this.addOptionalFilter(new AudioFilterAPhasemeter(), filterifPresent);
    }

    default public boolean addFilterAstats(Consumer<AudioFilterAstats> filterifPresent) {
        AudioFilterAstats f = new AudioFilterAstats();
        f.setSelectedMetadatas();
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public boolean addFilterSilencedetect(Consumer<AudioFilterSilencedetect> filterifPresent) {
        AudioFilterSilencedetect f = new AudioFilterSilencedetect();
        f.setMono(true);
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public boolean addFilterVolumedetect(Consumer<AudioFilterVolumedetect> filterifPresent) {
        return this.addOptionalFilter(new AudioFilterVolumedetect(), filterifPresent);
    }

    default public boolean addFilterEbur128(Consumer<AudioFilterEbur128> filterifPresent) {
        AudioFilterEbur128 f = new AudioFilterEbur128();
        f.setPeakMode(new TreeSet<AudioFilterEbur128.Peak>(List.of(AudioFilterEbur128.Peak.SAMPLE, AudioFilterEbur128.Peak.TRUE)));
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public boolean addFilterSiti(Consumer<VideoFilterSiti> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterSiti(), filterifPresent);
    }

    default public boolean addFilterIdet(Consumer<VideoFilterIdet> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterIdet(), filterifPresent);
    }

    default public boolean addFilterFreezedetect(Consumer<VideoFilterFreezedetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterFreezedetect(), filterifPresent);
    }

    default public boolean addFilterBlackdetect(Consumer<VideoFilterBlackdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlackdetect(), filterifPresent);
    }

    default public boolean addFilterCropdetect(Consumer<VideoFilterCropdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterCropdetect(), filterifPresent);
    }

    default public boolean addFilterBlockdetect(Consumer<VideoFilterBlockdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlockdetect(), filterifPresent);
    }

    default public boolean addFilterBlurdetect(Consumer<VideoFilterBlurdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlurdetect(), filterifPresent);
    }

    default public boolean addFilterMEstimate(Consumer<VideoFilterMEstimate> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterMEstimate(), filterifPresent);
    }

    default public boolean addFilterMetadata(Consumer<VideoFilterMetadata> filterifPresent) {
        VideoFilterMetadata vMetadata = new VideoFilterMetadata(AbstractFilterMetadata.Mode.PRINT);
        vMetadata.setFile("-");
        return this.addOptionalFilter(vMetadata, filterifPresent);
    }

    default public boolean addFilterAMetadata(Consumer<AudioFilterAMetadata> filterifPresent) {
        AudioFilterAMetadata aMetadata = new AudioFilterAMetadata(AbstractFilterMetadata.Mode.PRINT);
        aMetadata.setFile("-");
        return this.addOptionalFilter(aMetadata, filterifPresent);
    }

    default public <T extends AudioFilterSupplier> boolean addOptionalFilter(T filter, Consumer<T> filterifPresent) {
        if (this.addFilter(filter)) {
            filterifPresent.accept(filter);
            return true;
        }
        return false;
    }

    default public <T extends VideoFilterSupplier> boolean addOptionalFilter(T filter, Consumer<T> filterifPresent) {
        if (this.addFilter(filter)) {
            filterifPresent.accept(filter);
            return true;
        }
        return false;
    }
}

