/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.filtering.FilterArgument;
import tv.hd3g.fflauncher.filtering.parser.FilterParserBaseChainFilter;
import tv.hd3g.fflauncher.filtering.parser.FilterParserChars;

class FilterParserFilter
extends FilterParserBaseChainFilter {
    FilterParserFilter(List<FilterParserChars> content) {
        super(content);
    }

    FilterParserFilter(String content) {
        super(content);
    }

    String getFilterName() {
        return this.content.stream().takeWhile(c -> !c.isEquals()).map(FilterParserChars::toString).collect(Collectors.joining());
    }

    List<FilterArgument> getFilterArguments() {
        List<FilterParserChars> sub = this.content.stream().dropWhile(c -> !c.isEquals()).skip(1L).toList();
        ArrayList<FilterArgument> entries = new ArrayList<FilterArgument>();
        ArrayList<FilterParserChars> currentParam = new ArrayList<FilterParserChars>();
        for (int pos = 0; pos < sub.size(); ++pos) {
            FilterParserChars current = sub.get(pos);
            if (current.isColon()) {
                if (currentParam.isEmpty()) continue;
                entries.add(FilterParserFilter.getSetupKV(currentParam));
                currentParam = new ArrayList();
                continue;
            }
            currentParam.add(current);
        }
        if (!currentParam.isEmpty()) {
            entries.add(FilterParserFilter.getSetupKV(currentParam));
        }
        return Collections.unmodifiableList(entries);
    }

    static FilterArgument getSetupKV(List<FilterParserChars> param) {
        String key = null;
        String value = null;
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < param.size(); ++pos) {
            FilterParserChars current = param.get(pos);
            if (current.isEquals()) {
                if (sb.length() == 0) continue;
                if (key == null) {
                    key = sb.toString();
                } else {
                    value = sb.toString();
                }
                sb = new StringBuilder();
                continue;
            }
            current.write(sb);
        }
        if (sb.length() > 0) {
            if (key == null) {
                key = sb.toString();
            } else {
                value = sb.toString();
            }
        }
        return new FilterArgument(key, value);
    }
}

