/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.lavfimtd;

import java.util.Optional;

public interface NumberParserTraits {
    default public boolean stringNullOrBlank(String value) {
        return value == null || value.isBlank();
    }

    default public float parseFloat(String value) {
        if (this.stringNullOrBlank(value)) {
            return Float.NaN;
        }
        if (value.equalsIgnoreCase("-inf")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (value.equalsIgnoreCase("inf")) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    default public Double parseDouble(String value) {
        if (this.stringNullOrBlank(value)) {
            return Double.NaN;
        }
        if (value.equalsIgnoreCase("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value.equalsIgnoreCase("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    default public Optional<Integer> parseInt(String value) {
        if (this.stringNullOrBlank(value)) {
            return Optional.empty();
        }
        if (value.contains(".")) {
            return Optional.ofNullable(Math.round(this.parseFloat(value)));
        }
        try {
            return Optional.ofNullable(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public Optional<Long> parseLong(String value) {
        if (this.stringNullOrBlank(value)) {
            return Optional.empty();
        }
        if (value.contains(".")) {
            return Optional.ofNullable(Math.round(this.parseDouble(value)));
        }
        try {
            return Optional.ofNullable(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    default public int parseIntOrNeg1(String value) {
        return this.parseInt(value).orElse(-1);
    }

    default public long parseLongOrNeg1(String value) {
        return this.parseLong(value).orElse(-1L);
    }

    default public float parseFloatOrNeg1(String value) {
        float val = this.parseFloat(value);
        if (!Float.isFinite(val)) {
            return -1.0f;
        }
        return val;
    }
}

