/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.time.Duration;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;

public class VideoFilterBlackdetect
implements VideoFilterSupplier {
    private Duration blackMinDuration;
    private float pictureBlackRatioTh = -1.0f;
    private float pixelBlackTh = -1.0f;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("blackdetect");
        f.addOptionalDurationSecMsArgument("black_min_duration", this.blackMinDuration);
        f.addOptionalNonNegativeArgument("picture_black_ratio_th", this.pictureBlackRatioTh);
        f.addOptionalNonNegativeArgument("pixel_black_th", this.pixelBlackTh);
        return f;
    }

    public Duration getBlackMinDuration() {
        return this.blackMinDuration;
    }

    public float getPictureBlackRatioTh() {
        return this.pictureBlackRatioTh;
    }

    public float getPixelBlackTh() {
        return this.pixelBlackTh;
    }

    public void setBlackMinDuration(Duration blackMinDuration) {
        this.blackMinDuration = blackMinDuration;
    }

    public void setPictureBlackRatioTh(float pictureBlackRatioTh) {
        this.pictureBlackRatioTh = pictureBlackRatioTh;
    }

    public void setPixelBlackTh(float pixelBlackTh) {
        this.pixelBlackTh = pixelBlackTh;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterBlackdetect)) {
            return false;
        }
        VideoFilterBlackdetect other = (VideoFilterBlackdetect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getPictureBlackRatioTh(), other.getPictureBlackRatioTh()) != 0) {
            return false;
        }
        if (Float.compare(this.getPixelBlackTh(), other.getPixelBlackTh()) != 0) {
            return false;
        }
        Duration this$blackMinDuration = this.getBlackMinDuration();
        Duration other$blackMinDuration = other.getBlackMinDuration();
        return !(this$blackMinDuration == null ? other$blackMinDuration != null : !((Object)this$blackMinDuration).equals(other$blackMinDuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterBlackdetect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getPictureBlackRatioTh());
        result = result * 59 + Float.floatToIntBits(this.getPixelBlackTh());
        Duration $blackMinDuration = this.getBlackMinDuration();
        result = result * 59 + ($blackMinDuration == null ? 43 : ((Object)$blackMinDuration).hashCode());
        return result;
    }

    public String toString() {
        return "VideoFilterBlackdetect(blackMinDuration=" + this.getBlackMinDuration() + ", pictureBlackRatioTh=" + this.getPictureBlackRatioTh() + ", pixelBlackTh=" + this.getPixelBlackTh() + ")";
    }
}

