/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilterArgument {
    private final String key;
    private String value;

    public FilterArgument(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public FilterArgument(String key, Number value) {
        this.key = key;
        this.value = String.valueOf(value);
    }

    public FilterArgument(String key, Enum<?> value) {
        this.key = key;
        this.value = value.toString();
    }

    public FilterArgument(String key, Collection<?> values, String join) {
        this(key, values.stream(), join);
    }

    public FilterArgument(String key, Stream<?> values, String join) {
        this.key = key;
        this.value = values.map(Object::toString).collect(Collectors.joining(join));
    }

    public FilterArgument(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        if (this.value != null) {
            return this.key + "=" + this.value;
        }
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterArgument other = (FilterArgument)obj;
        return Objects.equals(this.key, other.key);
    }
}

