/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.acm.ACMAudioStreamToSplitList;
import tv.hd3g.fflauncher.acm.ACMExportableMapReference;
import tv.hd3g.fflauncher.acm.ACMLinkableOutStreamReference;
import tv.hd3g.fflauncher.acm.ACMListIndexPositionHandler;
import tv.hd3g.fflauncher.acm.ACMMapDirectly;
import tv.hd3g.fflauncher.acm.ACMMergeJoinToStreamDefinitionFilter;
import tv.hd3g.fflauncher.acm.ACMRemapDefinitionFilter;
import tv.hd3g.fflauncher.acm.ACMSplitInStreamDefinitionFilter;
import tv.hd3g.fflauncher.acm.InputAudioChannelSelector;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioStream;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.FilterChains;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.ffprobejaxb.FFprobeReference;
import tv.hd3g.ffprobejaxb.data.FFProbeStream;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.cmdline.SimpleParameters;

public class AudioChannelManipulation {
    static final Pattern checkClassicStreamDesc = Pattern.compile("^[0-9]*\\:[0-9]*$");
    private final List<ACMSplitInStreamDefinitionFilter> toSplitFilterList;
    private final List<ACMMergeJoinToStreamDefinitionFilter> amergeJoinList;
    private final Map<OutputAudioStream, ACMRemapDefinitionFilter> streamRemapFilterMap;
    private final List<OutputAudioStream> allOutputStreamList;

    public AudioChannelManipulation(List<OutputAudioStream> allOutputStreamList) {
        this.allOutputStreamList = allOutputStreamList;
        LinkedHashMap mapDirectlyMap = new LinkedHashMap();
        LinkedHashMap streamRemapMap = new LinkedHashMap();
        this.streamRemapFilterMap = Collections.unmodifiableMap(streamRemapMap);
        allOutputStreamList.stream().forEach(outStream -> {
            boolean straightMapping;
            int layoutOutChannelSize = outStream.getLayout().getChannelSize();
            List<InputAudioStream> allSelectedInStream = outStream.getChannels().stream().map(OutputAudioStream.OutputAudioChannel::getInputAudioStream).distinct().toList();
            if (allSelectedInStream.size() > 1) {
                return;
            }
            InputAudioStream selectedInStream = allSelectedInStream.get(0);
            if (selectedInStream.getLayout().getChannelSize() != layoutOutChannelSize) {
                return;
            }
            if (selectedInStream.getLayout() == outStream.getLayout() && (straightMapping = outStream.getChannels().stream().noneMatch(outChannel -> {
                int chOutPos;
                int chInPos = outChannel.getChInIndex().getPosInStream();
                return chInPos != (chOutPos = outChannel.getChOutIndex().getPosInStream());
            }))) {
                mapDirectlyMap.put(outStream, new ACMMapDirectly(selectedInStream, (OutputAudioStream)outStream));
                return;
            }
            streamRemapMap.put(outStream, new ACMRemapDefinitionFilter(selectedInStream, (OutputAudioStream)outStream));
        });
        List<OutputAudioStream.OutputAudioChannel> toProcess = allOutputStreamList.stream().flatMap(s -> s.getChannels().stream()).sorted().filter(ch -> !mapDirectlyMap.containsKey(ch.getOutputAudioStream()) && !streamRemapMap.containsKey(ch.getOutputAudioStream())).toList();
        ACMAudioStreamToSplitList toSplit = new ACMAudioStreamToSplitList();
        this.toSplitFilterList = Collections.unmodifiableList(toSplit);
        AtomicInteger counter = new AtomicInteger(0);
        toProcess.stream().filter(ch -> !ch.getInputAudioStream().getLayout().isMonoLayout()).forEach(ch -> {
            Optional<ACMSplitInStreamDefinitionFilter> optSplit = toSplit.findFirst(ch.getInputAudioStream());
            if (optSplit.isPresent()) {
                ACMSplitInStreamDefinitionFilter splitterByInStream = optSplit.get();
                if (splitterByInStream.getSplittedOut().containsKey(ch.getChInIndex())) {
                    toSplit.add(new ACMSplitInStreamDefinitionFilter((OutputAudioStream.OutputAudioChannel)ch, counter.getAndIncrement()));
                } else {
                    Map<InputAudioChannelSelector, ACMSplitInStreamDefinitionFilter.SplittedOut> map = splitterByInStream.getSplittedOut();
                    InputAudioChannelSelector inputAudioChannelSelector = ch.getChInIndex();
                    ACMSplitInStreamDefinitionFilter aCMSplitInStreamDefinitionFilter = splitterByInStream;
                    Objects.requireNonNull(aCMSplitInStreamDefinitionFilter);
                    map.put(inputAudioChannelSelector, new ACMSplitInStreamDefinitionFilter.SplittedOut(aCMSplitInStreamDefinitionFilter, (OutputAudioStream.OutputAudioChannel)ch, counter.getAndIncrement()));
                }
            } else {
                toSplit.add(new ACMSplitInStreamDefinitionFilter((OutputAudioStream.OutputAudioChannel)ch, counter.getAndIncrement()));
            }
        });
        ArrayList mapDirectlySplited = new ArrayList();
        this.amergeJoinList = new ArrayList<ACMMergeJoinToStreamDefinitionFilter>();
        allOutputStreamList.stream().filter(outStream -> !mapDirectlyMap.containsKey(outStream) && !streamRemapMap.containsKey(outStream)).forEach(outStream -> {
            if (outStream.getLayout() == ChannelLayout.MONO) {
                OutputAudioStream.OutputAudioChannel outChannel = outStream.getChannels().stream().findFirst().orElse(null);
                ACMSplitInStreamDefinitionFilter.SplittedOut splittedOut = toSplit.search(outChannel).orElseThrow(() -> new IllegalStateException("nCh to 1Ch, missing toSplit list item"));
                mapDirectlySplited.add(splittedOut);
                return;
            }
            ArrayList<ACMExportableMapReference> mergeJoinCurrentList = new ArrayList<ACMExportableMapReference>();
            outStream.getChannels().stream().sorted().forEach(channel -> {
                ACMExportableMapReference toMergeJoin = toSplit.search((OutputAudioStream.OutputAudioChannel)channel).map(ACMExportableMapReference.class::cast).orElseGet(channel::getInputAudioStream);
                mergeJoinCurrentList.add(toMergeJoin);
            });
            this.amergeJoinList.add(new ACMMergeJoinToStreamDefinitionFilter((List<ACMExportableMapReference>)mergeJoinCurrentList, (OutputAudioStream)outStream));
        });
        Stream.of(this.amergeJoinList, mapDirectlySplited, streamRemapMap.values().stream().toList()).forEach(l -> {
            for (int pos = 0; pos < l.size(); ++pos) {
                ((ACMListIndexPositionHandler)l.get(pos)).setAbsoluteIndex(pos);
            }
        });
        Collector<Object, ?, Map<OutputAudioStream, String>> collectorForReferenceByOutStreams = Collectors.toUnmodifiableMap(k -> ((ACMLinkableOutStreamReference)k).getLinkableOutStreamReference(), k -> ((ACMExportableMapReference)k).toMapReferenceAsInput());
        List<Map<OutputAudioStream, String>> referenceByOutStreams = List.of(this.amergeJoinList.stream().collect(collectorForReferenceByOutStreams), mapDirectlySplited.stream().collect(collectorForReferenceByOutStreams), streamRemapMap.values().stream().collect(collectorForReferenceByOutStreams), mapDirectlyMap.values().stream().collect(collectorForReferenceByOutStreams));
        allOutputStreamList.forEach(outStream -> {
            List<String> streamRefs = referenceByOutStreams.stream().filter(ref -> ref.containsKey(outStream)).map(ref -> (String)ref.get(outStream)).toList();
            outStream.setMapReference(streamRefs.get(0));
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("split: ");
        sb.append(this.toSplitFilterList);
        sb.append(", merge/join: ");
        sb.append(this.amergeJoinList);
        sb.append(", remap: ");
        sb.append(this.streamRemapFilterMap);
        sb.append(", map: ");
        sb.append(this.allOutputStreamList);
        return sb.toString();
    }

    List<ACMSplitInStreamDefinitionFilter> getToSplitFilterList() {
        return this.toSplitFilterList;
    }

    List<ACMMergeJoinToStreamDefinitionFilter> getMergeJoinList() {
        return this.amergeJoinList;
    }

    Map<OutputAudioStream, ACMRemapDefinitionFilter> getStreamRemapFilterMap() {
        return this.streamRemapFilterMap;
    }

    List<OutputAudioStream> getAllOutputStreams() {
        return this.allOutputStreamList;
    }

    public List<Parameters> getMapParameters(BiFunction<Integer, OutputAudioStream, Parameters> parametersMapper) {
        ArrayList<Parameters> fileParameters = new ArrayList<Parameters>();
        Parameters currentParameters = null;
        for (int pos = 0; pos < this.allOutputStreamList.size(); ++pos) {
            OutputAudioStream outStream = this.allOutputStreamList.get(pos);
            if (fileParameters.size() - 1 != outStream.getFileIndex()) {
                currentParameters = new Parameters();
                fileParameters.add(currentParameters);
            }
            Parameters map = parametersMapper.apply(pos, outStream);
            Objects.requireNonNull(currentParameters).addAllFrom((SimpleParameters)map);
        }
        return Collections.unmodifiableList(fileParameters);
    }

    private static Parameters getMapStreamParam(String mapRef) {
        if (checkClassicStreamDesc.matcher(mapRef).find()) {
            return Parameters.of((String[])new String[]{"-map", mapRef});
        }
        return Parameters.of((String[])new String[]{"-map", "[" + mapRef + "]"});
    }

    public List<Parameters> getMapParameters() {
        return this.getMapParameters((Integer pos, OutputAudioStream astream) -> AudioChannelManipulation.getMapStreamParam(astream.toMapReferenceAsInput()));
    }

    public List<Parameters> getMapParameters(List<String> prependToMapList) {
        Stream<Parameters> prepend = prependToMapList.stream().map(AudioChannelManipulation::getMapStreamParam);
        return Stream.of(prepend, this.getMapParameters().stream()).flatMap(p -> p).toList();
    }

    public List<Parameters> getMapParameters(List<FFprobeJAXB> sourceFiles, BiPredicate<Integer, FFProbeStream> addNonAudioStreamFromSources) {
        LinkedHashMap selectedFileStreams = new LinkedHashMap();
        for (int pos = 0; pos < sourceFiles.size(); ++pos) {
            int fileIndex = pos;
            sourceFiles.get(pos).getStreams().stream().filter(s -> FFprobeReference.filterVideoStream.test(s) || FFprobeReference.filterDataStream.test(s)).filter(s -> addNonAudioStreamFromSources.test(fileIndex, (FFProbeStream)s)).forEach(s -> selectedFileStreams.put(fileIndex, s));
        }
        return this.getMapParameters(selectedFileStreams.entrySet().stream().map(entry -> {
            Integer fileIndex = (Integer)entry.getKey();
            FFProbeStream streamInFile = (FFProbeStream)entry.getValue();
            return fileIndex + ":" + streamInFile.index();
        }).toList());
    }

    public FilterChains getFilterChains(boolean useJoinInsteadOfMerge) {
        FilterChains chain = new FilterChains();
        this.toSplitFilterList.forEach(s -> chain.addFilterInLastChain(s.toFilter(), true));
        if (useJoinInsteadOfMerge) {
            this.amergeJoinList.forEach(s -> chain.addFilterInLastChain(s.toJoinFilter(), true));
        } else {
            this.amergeJoinList.forEach(s -> chain.addFilterInLastChain(s.toAmergeFilter(), true));
        }
        this.streamRemapFilterMap.values().stream().forEach(remapDefinitionFilter -> chain.addFilterInLastChain(remapDefinitionFilter.toFilter(), true));
        return chain;
    }
}

