/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.about;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.UnknownFormatException;

public class FFAboutPixelFormat {
    public final boolean supportedInput;
    public final boolean supportedOutput;
    public final boolean hardwareAccelerated;
    public final boolean paletted;
    public final boolean bitstream;
    public final int nbComponents;
    public final int bitsPerPixel;
    public final BitDepths bitDepths;
    public final String tag;

    static List<FFAboutPixelFormat> parsePixelsFormats(List<String> lines) {
        return lines.stream().map(String::trim).filter(line -> !line.toLowerCase().startsWith("Pixel formats:".toLowerCase())).filter(line -> !line.contains("=")).filter(line -> !line.toLowerCase().startsWith("FLAGS".toLowerCase())).filter(line -> !line.startsWith("-----")).map(FFAboutPixelFormat::new).toList();
    }

    FFAboutPixelFormat(String line) {
        List<String> lineBlocs = Arrays.stream(line.split(" ")).filter(lb -> !lb.trim().equals("")).map(String::trim).toList();
        if (lineBlocs.size() < 4 || lineBlocs.size() > 5) {
            throw new UnknownFormatException("Can't parse line: \"" + line + "\"");
        }
        this.supportedInput = lineBlocs.get(0).contains("I");
        this.supportedOutput = lineBlocs.get(0).contains("O");
        this.hardwareAccelerated = lineBlocs.get(0).contains("H");
        this.paletted = lineBlocs.get(0).contains("P");
        this.bitstream = lineBlocs.get(0).contains("B");
        this.tag = lineBlocs.get(1);
        this.nbComponents = Integer.parseInt(lineBlocs.get(2));
        this.bitsPerPixel = Integer.parseInt(lineBlocs.get(3));
        this.bitDepths = lineBlocs.size() == 5 ? BitDepths.getFromTag(lineBlocs.get(4)) : BitDepths.Unknown;
    }

    public static enum BitDepths {
        Unknown(""),
        BitDepths_0("0"),
        BitDepths_1("1"),
        BitDepths_10("10"),
        BitDepths_10_10_10("10-10-10"),
        BitDepths_10_10_10_10("10-10-10-10"),
        BitDepths_12("12"),
        BitDepths_1_2_1("1-2-1"),
        BitDepths_12_12_12("12-12-12"),
        BitDepths_12_12_12_12("12-12-12-12"),
        BitDepths_14("14"),
        BitDepths_14_14_14("14-14-14"),
        BitDepths_16("16"),
        BitDepths_16_16("16-16"),
        BitDepths_16_16_16("16-16-16"),
        BitDepths_16_16_16_16("16-16-16-16"),
        BitDepths_2_3_3("2-3-3"),
        BitDepths_2_4_2("2-4-2"),
        BitDepths_32("32"),
        BitDepths_32_32_32("32-32-32"),
        BitDepths_32_32_32_32("32-32-32-32"),
        BitDepths_3_3_2("3-3-2"),
        BitDepths_4_4_4("4-4-4"),
        BitDepths_4_8_4("4-8-4"),
        BitDepths_5_5_5("5-5-5"),
        BitDepths_5_6_5("5-6-5"),
        BitDepths_8("8"),
        BitDepths_8_8("8-8"),
        BitDepths_8_8_8("8-8-8"),
        BitDepths_8_8_8_8("8-8-8-8"),
        BitDepths_9("9"),
        BitDepths_9_9_9("9-9-9"),
        BitDepths_9_9_9_9("9-9-9-9");

        public final String tag;

        private BitDepths(String tag) {
            this.tag = tag;
        }

        public String toString() {
            return this.tag;
        }

        public static BitDepths getFromTag(String tag) {
            Objects.requireNonNull(tag);
            return Stream.of(BitDepths.values()).filter(bD -> bD.tag.equals(tag)).findFirst().orElse(Unknown);
        }
    }
}

