/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.fflauncher.ConversionToolParameterReference;
import tv.hd3g.fflauncher.InputSourceProviderTraits;
import tv.hd3g.fflauncher.InternalParametersSupplier;
import tv.hd3g.fflauncher.enums.OutputFilePresencePolicy;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.CapturedStdOutErrToPrintStream;
import tv.hd3g.processlauncher.ExecutableTool;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.cmdline.SimpleParameters;

public class ConversionTool
implements ExecutableTool,
InternalParametersSupplier,
InputSourceProviderTraits {
    private static final Logger log = LoggerFactory.getLogger(ConversionTool.class);
    private static final Predicate<LineEntry> ignoreAllLinesEventsToDisplay = le -> false;
    protected final String execName;
    protected final List<ConversionToolParameterReference> inputSources;
    protected final List<ConversionToolParameterReference> outputExpectedDestinations;
    private final LinkedHashMap<String, Parameters> parametersVariables;
    private File workingDirectory;
    private long maxExecTimeMs;
    private ScheduledExecutorService maxExecTimeScheduler;
    private boolean removeParamsIfNoVarToInject;
    protected final Parameters parameters;
    private boolean onErrorDeleteOutFiles;
    private boolean checkSourcesBeforeReady;
    private Optional<Predicate<LineEntry>> filterForLinesEventsToDisplay;
    public static final BiConsumer<Parameters, String> APPEND_PARAM_AT_END = (rec$, xva$0) -> ((SimpleParameters)rec$).addParameters(new String[]{xva$0});
    public static final BiConsumer<Parameters, String> PREPEND_PARAM_AT_START = (rec$, xva$0) -> ((SimpleParameters)rec$).prependParameters(new String[]{xva$0});

    public ConversionTool(String execName) {
        this(execName, new Parameters());
    }

    protected ConversionTool(String execName, Parameters parameters) {
        this.execName = Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.parameters = Objects.requireNonNull(parameters, "\"parameters\" can't to be null");
        this.maxExecTimeMs = 5000L;
        this.inputSources = new ArrayList<ConversionToolParameterReference>();
        this.outputExpectedDestinations = new ArrayList<ConversionToolParameterReference>();
        this.parametersVariables = new LinkedHashMap();
        this.checkSourcesBeforeReady = true;
        this.filterForLinesEventsToDisplay = Optional.ofNullable(ignoreAllLinesEventsToDisplay);
    }

    public boolean isRemoveParamsIfNoVarToInject() {
        return this.removeParamsIfNoVarToInject;
    }

    public ConversionTool setRemoveParamsIfNoVarToInject(boolean remove_params_if_no_var_to_inject) {
        this.removeParamsIfNoVarToInject = remove_params_if_no_var_to_inject;
        return this;
    }

    public ConversionTool setMaxExecutionTimeForShortCommands(long max_exec_time, TimeUnit unit) {
        this.maxExecTimeMs = unit.toMillis(max_exec_time);
        return this;
    }

    public ConversionTool setMaxExecTimeScheduler(ScheduledExecutorService maxExecTimeScheduler) {
        this.maxExecTimeScheduler = maxExecTimeScheduler;
        return this;
    }

    public long getMaxExecTime(TimeUnit unit) {
        return unit.convert(this.maxExecTimeMs, TimeUnit.MILLISECONDS);
    }

    public ScheduledExecutorService getMaxExecTimeScheduler() {
        return this.maxExecTimeScheduler;
    }

    public ConversionTool setFilterForLinesEventsToDisplay(Predicate<LineEntry> filterForLinesEventsToDisplay) {
        this.filterForLinesEventsToDisplay = Optional.ofNullable(filterForLinesEventsToDisplay);
        return this;
    }

    public Optional<Predicate<LineEntry>> getFilterForLinesEventsToDisplay() {
        return this.filterForLinesEventsToDisplay;
    }

    public Map<String, Parameters> getParametersVariables() {
        return this.parametersVariables;
    }

    @Override
    public ConversionTool addInputSource(String source, String varNameInParameters, Collection<String> parametersBeforeInputSource) {
        this.inputSources.add(new ConversionToolParameterReference(source, this.patchVarName(varNameInParameters), parametersBeforeInputSource));
        return this;
    }

    protected String patchVarName(String rawVarName) {
        if (this.parameters.isTaggedParameter(rawVarName)) {
            return rawVarName;
        }
        if (rawVarName.startsWith(this.parameters.getStartVarTag())) {
            return rawVarName + this.parameters.getEndVarTag();
        }
        if (rawVarName.endsWith(this.parameters.getEndVarTag())) {
            return this.parameters.getStartVarTag() + rawVarName;
        }
        return this.parameters.tagVar(rawVarName);
    }

    @Override
    public ConversionTool addInputSource(File source, String varNameInParameters, Collection<String> parametersBeforeInputSource) {
        this.inputSources.add(new ConversionToolParameterReference(source, this.patchVarName(varNameInParameters), parametersBeforeInputSource));
        return this;
    }

    @Override
    public List<ConversionToolParameterReference> getInputSources() {
        return this.inputSources;
    }

    public ConversionTool addOutputDestination(String destination, String varNameInParameters, String ... parametersBeforeOutputDestination) {
        if (parametersBeforeOutputDestination != null) {
            return this.addOutputDestination(destination, varNameInParameters, Arrays.stream(parametersBeforeOutputDestination).filter(Objects::nonNull).toList());
        }
        return this.addOutputDestination(destination, varNameInParameters, Collections.emptyList());
    }

    public ConversionTool addOutputDestination(File destination, String varNameInParameters, String ... parametersBeforeOutputDestination) {
        if (parametersBeforeOutputDestination != null) {
            return this.addOutputDestination(destination, varNameInParameters, Arrays.stream(parametersBeforeOutputDestination).filter(Objects::nonNull).toList());
        }
        return this.addOutputDestination(destination, varNameInParameters, Collections.emptyList());
    }

    public ConversionTool addOutputDestination(String destination, String varNameInParameters, Collection<String> parametersBeforeOutputDestination) {
        this.outputExpectedDestinations.add(new ConversionToolParameterReference(destination, this.patchVarName(varNameInParameters), parametersBeforeOutputDestination));
        return this;
    }

    public ConversionTool addOutputDestination(File destination, String varNameInParameters, Collection<String> parametersBeforeOutputDestination) {
        this.outputExpectedDestinations.add(new ConversionToolParameterReference(destination, this.patchVarName(varNameInParameters), parametersBeforeOutputDestination));
        return this;
    }

    protected void onMissingInputOutputVar(String var_name, String ressource) {
        log.warn("Missing I/O variable \"{}\" in command line \"{}\". Ressource \"{}\" will be ignored", new Object[]{var_name, this.getInternalParameters(), ressource});
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ConversionTool setWorkingDirectory(File workingDirectory) throws IOException {
        Objects.requireNonNull(workingDirectory, "\"workingDirectory\" can't to be null");
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" in filesytem");
        }
        if (!workingDirectory.canRead()) {
            throw new IOException("Can't read workingDirectory \"" + workingDirectory.getPath() + "\"");
        }
        if (!workingDirectory.isDirectory()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" is not a directory");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    public boolean isOnErrorDeleteOutFiles() {
        return this.onErrorDeleteOutFiles;
    }

    public ConversionTool setOnErrorDeleteOutFiles(boolean onErrorDeleteOutFiles) {
        this.onErrorDeleteOutFiles = onErrorDeleteOutFiles;
        return this;
    }

    public void beforeRun(ProcesslauncherBuilder processBuilder) {
        if (this.maxExecTimeScheduler != null) {
            processBuilder.setExecutionTimeLimiter(this.maxExecTimeMs, TimeUnit.MILLISECONDS, this.maxExecTimeScheduler);
        }
        if (this.workingDirectory != null) {
            try {
                processBuilder.setWorkingDirectory(this.workingDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.onErrorDeleteOutFiles) {
            processBuilder.addExecutionCallbacker(lifecycle -> {
                if (!lifecycle.isCorrectlyDone()) {
                    log.warn("Error during execution of \"{}\", remove output files", (Object)lifecycle);
                    this.cleanUpOutputFiles(true, true);
                }
            });
        }
        this.filterForLinesEventsToDisplay.filter(ffletd -> !ignoreAllLinesEventsToDisplay.equals(ffletd)).ifPresent(filter -> {
            CapturedStdOutErrToPrintStream psOut = new CapturedStdOutErrToPrintStream(this.getStdOutPrintStreamToDisplayLinesEvents(), this.getStdErrPrintStreamToDisplayLinesEvents());
            psOut.setFilter(filter);
            processBuilder.getSetCaptureStandardOutputAsOutputText().addObserver((CapturedStdOutErrText)psOut);
        });
    }

    protected PrintStream getStdOutPrintStreamToDisplayLinesEvents() {
        return System.out;
    }

    protected PrintStream getStdErrPrintStreamToDisplayLinesEvents() {
        return System.err;
    }

    public Optional<String> getDeclaredSourceByVarName(String varName) {
        return this.inputSources.stream().filter(paramRef -> paramRef.isVarNameInParametersEquals(varName)).map(ConversionToolParameterReference::getRessource).findFirst();
    }

    public Optional<String> getDeclaredDestinationByVarName(String varName) {
        return this.outputExpectedDestinations.stream().filter(paramRef -> paramRef.isVarNameInParametersEquals(varName)).map(ConversionToolParameterReference::getRessource).findFirst();
    }

    public List<String> getDeclaredSources() {
        return this.inputSources.stream().map(ConversionToolParameterReference::getRessource).toList();
    }

    public List<String> getDeclaredDestinations() {
        return this.outputExpectedDestinations.stream().map(ConversionToolParameterReference::getRessource).toList();
    }

    public ConversionTool addSimpleOutputDestination(String destinationName) {
        Objects.requireNonNull(destinationName, "\"destinationName\" can't to be null");
        String varname = this.parameters.tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationName, varname, new String[0]);
        return this;
    }

    public ConversionTool addSimpleOutputDestination(File destinationFile) {
        Objects.requireNonNull(destinationFile, "\"destinationFile\" can't to be null");
        String varname = this.parameters.tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationFile, varname, new String[0]);
        return this;
    }

    public List<File> getOutputFiles(OutputFilePresencePolicy filterPolicy) {
        return this.outputExpectedDestinations.stream().map(ConversionToolParameterReference::getRessource).flatMap(ressource -> {
            try {
                URL url = new URL((String)ressource);
                if (url.getProtocol().equals("file")) {
                    return Stream.of(Paths.get(url.toURI()).toFile());
                }
            }
            catch (MalformedURLException e) {
                return Stream.of(new File((String)ressource));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return Stream.empty();
        }).map(file -> {
            if (!file.exists() && this.getWorkingDirectory() != null) {
                return new File(this.getWorkingDirectory().getAbsolutePath() + File.separator + file.getPath());
            }
            return file;
        }).distinct().filter(filterPolicy.filter()).toList();
    }

    public ConversionTool cleanUpOutputFiles(boolean remove_all, boolean clean_output_directories) {
        this.getOutputFiles(OutputFilePresencePolicy.MUST_EXISTS).stream().filter(file -> {
            if (!file.isFile()) {
                return clean_output_directories;
            }
            return !(!remove_all && file.length() > 0L);
        }).filter(file -> {
            if (file.isFile()) {
                log.info("Delete file \"{}\"", file);
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return false;
            }
            return true;
        }).map(File::toPath).flatMap(dirPath -> {
            Stream stream;
            block8: {
                Stream<Path> fWalk = Files.walk(dirPath, new FileVisitOption[0]);
                try {
                    stream = fWalk.sorted(Comparator.reverseOrder()).map(Path::toFile).toList().stream();
                    if (fWalk == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fWalk != null) {
                            try {
                                fWalk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error("Can't access to {}", dirPath, (Object)e);
                        return Stream.empty();
                    }
                }
                fWalk.close();
            }
            return stream;
        }).forEach(file -> {
            log.info("Delete \"{}\"", file);
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return this;
    }

    @Override
    public Parameters getInternalParameters() {
        return this.parameters;
    }

    public ConversionTool setCheckSourcesBeforeReady(boolean checkSourcesBeforeReady) {
        this.checkSourcesBeforeReady = checkSourcesBeforeReady;
        return this;
    }

    public boolean isCheckSourcesBeforeReady() {
        return this.checkSourcesBeforeReady;
    }

    public ConversionTool checkSources() {
        this.inputSources.forEach(s -> {
            try {
                s.checkOpenRessourceAsFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(new IOException("Can't open file \"" + s + "\" for check reading", e));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        });
        return this;
    }

    public ConversionTool checkDestinations() {
        this.outputExpectedDestinations.forEach(s -> {
            try {
                s.checkOpenRessourceAsFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(new IOException("Can't open file \"" + s + "\" for check reading", e));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        });
        return this;
    }

    public void fixIOParametredVars(BiConsumer<Parameters, String> onMissingInputVar, BiConsumer<Parameters, String> onMissingOutputVar) {
        Set actualTaggedParameters = this.parameters.getParameters().stream().filter(arg_0 -> ((Parameters)this.parameters).isTaggedParameter(arg_0)).distinct().collect(Collectors.toUnmodifiableSet());
        this.inputSources.stream().map(ConversionToolParameterReference::getVarNameInParameters).filter(v -> !actualTaggedParameters.contains(v)).forEach(v -> onMissingInputVar.accept(this.parameters, (String)v));
        this.outputExpectedDestinations.stream().map(ConversionToolParameterReference::getVarNameInParameters).filter(v -> !actualTaggedParameters.contains(v)).forEach(v -> onMissingOutputVar.accept(this.parameters, (String)v));
        Stream.of(this.inputSources, this.outputExpectedDestinations).flatMap(Collection::stream).forEach(v -> v.manageCollisionsParameters(this.parameters));
    }

    public void fixIOParametredVars() {
        this.fixIOParametredVars(PREPEND_PARAM_AT_START, APPEND_PARAM_AT_END);
    }

    public Parameters getReadyToRunParameters() {
        if (this.checkSourcesBeforeReady) {
            this.checkSources();
        }
        HashMap<String, Parameters> allVarsToInject = new HashMap<String, Parameters>(this.parametersVariables);
        Parameters newerParameters = this.parameters.duplicate();
        Stream.concat(this.inputSources.stream(), this.outputExpectedDestinations.stream()).forEach(paramRef -> {
            String taggedVarName = paramRef.getVarNameInParameters();
            boolean done = newerParameters.injectParamsAroundVariable(newerParameters.extractVarNameFromTaggedParameter(taggedVarName), paramRef.getParametersListBeforeRef(), List.of());
            if (done) {
                if (allVarsToInject.containsKey(taggedVarName)) {
                    throw new IllegalStateException("Variable collision: \"" + taggedVarName + "\" was already set to \"" + allVarsToInject.get(taggedVarName) + "\" in " + newerParameters);
                }
                allVarsToInject.put(taggedVarName, Parameters.of((String[])new String[]{paramRef.getRessource()}));
            } else {
                this.onMissingInputOutputVar(taggedVarName, paramRef.getRessource());
            }
        });
        return newerParameters.injectVariables(allVarsToInject, this.removeParamsIfNoVarToInject);
    }

    public String getExecutableName() {
        return this.execName;
    }
}

