/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.List;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;

public class RawStdErrFilterEvent {
    private final String filterName;
    private final int filterChainPos;
    private final String lineValue;

    RawStdErrFilterEvent(String rawLine) {
        List<String> items = MediaAnalyser.splitter(rawLine, ' ');
        String head = items.get(0);
        List<String> headItems = MediaAnalyser.splitter(head, '_');
        this.filterName = headItems.get(1);
        this.filterChainPos = Integer.valueOf(headItems.get(2));
        if (!items.get(1).equals("@")) {
            throw new IllegalArgumentException("Missing \"@\" on line \"" + rawLine + "\"");
        }
        if (!items.get(2).endsWith("]")) {
            throw new IllegalArgumentException("Missing \"]\" on line \"" + rawLine + "\"");
        }
        int dataPos = rawLine.indexOf("]");
        this.lineValue = rawLine.substring(dataPos + 1).trim();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public int getFilterChainPos() {
        return this.filterChainPos;
    }

    public String getLineValue() {
        return this.lineValue;
    }

    public String toString() {
        return "RawStdErrFilterEvent(filterName=" + this.getFilterName() + ", filterChainPos=" + this.getFilterChainPos() + ", lineValue=" + this.getLineValue() + ")";
    }
}

