/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFmpeg;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.FilterChains;
import tv.hd3g.fflauncher.filtering.FilterSupplier;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMetadataFilterParser;
import tv.hd3g.fflauncher.recipes.BaseAnalyserSession;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;
import tv.hd3g.fflauncher.recipes.MediaAnalyserResult;
import tv.hd3g.fflauncher.recipes.MediaAnalyserSessionFilterContext;
import tv.hd3g.fflauncher.resultparser.Ebur128StrErrFilterEvent;
import tv.hd3g.fflauncher.resultparser.RawStdErrEventParser;
import tv.hd3g.fflauncher.resultparser.RawStdErrFilterEvent;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class MediaAnalyserSession
extends BaseAnalyserSession {
    private static final Logger log = LoggerFactory.getLogger(MediaAnalyserSession.class);
    private final MediaAnalyser mediaAnalyser;
    private final List<AudioFilterSupplier> audioFilters;
    private final List<VideoFilterSupplier> videoFilters;
    private final String source;
    private final File sourceFile;
    private FFprobeJAXB ffprobeResult;
    private BiConsumer<MediaAnalyserSession, Ebur128StrErrFilterEvent> ebur128EventConsumer;
    private BiConsumer<MediaAnalyserSession, RawStdErrFilterEvent> rawStdErrEventConsumer;
    private String pgmFFDuration;
    private String pgmFFStartTime;

    MediaAnalyserSession(MediaAnalyser mediaAnalyser, String source, File sourceFile) {
        this.mediaAnalyser = mediaAnalyser;
        if (source == null && sourceFile == null) {
            throw new IllegalArgumentException("No source for ffmpeg");
        }
        this.source = source;
        this.sourceFile = sourceFile;
        this.audioFilters = Collections.unmodifiableList(mediaAnalyser.getAudioFilters());
        this.videoFilters = Collections.unmodifiableList(mediaAnalyser.getVideoFilters());
        this.ebur128EventConsumer = (m, event) -> log.trace("On ebur128: {} on {}", event, m);
        this.rawStdErrEventConsumer = (m, event) -> log.trace("On rawStd: {} on {}", event, m);
    }

    public MediaAnalyserSession setFFprobeResult(FFprobeJAXB ffprobeResult) {
        this.ffprobeResult = ffprobeResult;
        return this;
    }

    public Optional<FFprobeJAXB> getFFprobeResult() {
        return Optional.ofNullable(this.ffprobeResult);
    }

    public void setEbur128EventConsumer(BiConsumer<MediaAnalyserSession, Ebur128StrErrFilterEvent> ebur128EventConsumer) {
        this.ebur128EventConsumer = Objects.requireNonNull(ebur128EventConsumer, "\"ebur128EventConsumer\" can't to be null");
    }

    public void setRawStdErrEventConsumer(BiConsumer<MediaAnalyserSession, RawStdErrFilterEvent> rawStdErrEventConsumer) {
        this.rawStdErrEventConsumer = Objects.requireNonNull(rawStdErrEventConsumer, "\"rawStdErrEventConsumer\" can't to be null");
    }

    public void setPgmFFDuration(String pgmFFDuration) {
        this.pgmFFDuration = pgmFFDuration;
    }

    public void setPgmFFStartTime(String pgmFFStartTime) {
        this.pgmFFStartTime = pgmFFStartTime;
    }

    private FFmpeg prepareFFmpeg() {
        FilterChains chain;
        if (this.audioFilters.isEmpty() && this.videoFilters.isEmpty()) {
            throw new IllegalArgumentException("No filters are sets");
        }
        if (this.ffprobeResult != null) {
            if (this.ffprobeResult.getAudiosStreams().count() == 0L && !this.audioFilters.isEmpty()) {
                throw new IllegalStateException("Can't apply audio filters if source don't have an audio stream!");
            }
            if (this.ffprobeResult.getFirstVideoStream().isEmpty() && !this.videoFilters.isEmpty()) {
                throw new IllegalStateException("Can't apply video filters if source don't have an video stream!");
            }
        }
        FFmpeg ffmpeg = this.mediaAnalyser.createFFmpeg();
        ffmpeg.setHidebanner();
        ffmpeg.setNostats();
        if (this.source != null) {
            ffmpeg.addSimpleInputSource(this.source, new String[0]);
        } else {
            ffmpeg.addSimpleInputSource(this.sourceFile, new String[0]);
        }
        if (!this.audioFilters.isEmpty()) {
            chain = new FilterChains();
            chain.createChain().addAll(this.audioFilters.stream().map(FilterSupplier::toFilter).toList());
            chain.pushFilterChainTo("-af", ffmpeg);
        } else {
            ffmpeg.setNoAudio();
        }
        if (!this.videoFilters.isEmpty()) {
            chain = new FilterChains();
            chain.createChain().addAll(this.videoFilters.stream().map(FilterSupplier::toFilter).toList());
            chain.pushFilterChainTo("-vf", ffmpeg);
        } else {
            ffmpeg.setNoVideo();
        }
        ffmpeg.addSimpleOutputDestination("-", "null");
        if (this.pgmFFDuration != null && !this.pgmFFDuration.isEmpty()) {
            ffmpeg.addDuration(this.pgmFFDuration);
        }
        if (this.pgmFFStartTime != null && !this.pgmFFStartTime.isEmpty()) {
            ffmpeg.addStartPosition(this.pgmFFStartTime);
        }
        ffmpeg.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        this.applyMaxExecTime(ffmpeg);
        return ffmpeg;
    }

    public MediaAnalyserResult process(Optional<Supplier<Stream<String>>> oLavfiLinesToMerge) {
        FFmpeg ffmpeg = this.prepareFFmpeg();
        LavfiMetadataFilterParser lavfiMetadataFilterParser = new LavfiMetadataFilterParser();
        RawStdErrEventParser rawStdErrEventParser = new RawStdErrEventParser(event -> {
            if (event.getFilterName().equals("ebur128")) {
                this.ebur128EventConsumer.accept(this, new Ebur128StrErrFilterEvent(event.getLineValue()));
            } else {
                this.rawStdErrEventConsumer.accept(this, (RawStdErrFilterEvent)event);
            }
        });
        CircularFifoQueue stdErrLinesBucket = new CircularFifoQueue(10);
        ProcesslauncherLifecycle processLifecycle = ffmpeg.execute(this.mediaAnalyser.getExecutableFinder(), lineEntry -> {
            String line = lineEntry.getLine();
            log.trace("Line: {}", (Object)line);
            if (!lineEntry.isStdErr()) {
                lavfiMetadataFilterParser.addLavfiRawLine(line);
            } else {
                rawStdErrEventParser.onLine(line);
                stdErrLinesBucket.add((Object)line.trim());
            }
        });
        log.debug("Start {}", (Object)processLifecycle.getLauncher().getFullCommandLine());
        processLifecycle.waitForEnd();
        boolean execOk = processLifecycle.isCorrectlyDone();
        if (!execOk) {
            String stdErr = stdErrLinesBucket.stream().collect(Collectors.joining("|"));
            throw new InvalidExecution(processLifecycle, stdErr);
        }
        oLavfiLinesToMerge.stream().flatMap(Supplier::get).forEach(lavfiMetadataFilterParser::addLavfiRawLine);
        Set<MediaAnalyserSessionFilterContext> filterSet = Stream.concat(this.audioFilters.stream().map(FilterSupplier::toFilter).filter(f -> !f.getFilterName().equals("ametadata")).map(f -> MediaAnalyserSessionFilterContext.getFromFilter(f, "audio")), this.videoFilters.stream().map(FilterSupplier::toFilter).filter(f -> !f.getFilterName().equals("metadata")).map(f -> MediaAnalyserSessionFilterContext.getFromFilter(f, "video"))).distinct().collect(Collectors.toUnmodifiableSet());
        return new MediaAnalyserResult(lavfiMetadataFilterParser.close(), rawStdErrEventParser.close(), filterSet);
    }

    public static MediaAnalyserResult importFromOffline(Stream<String> stdOutLines, Stream<String> stdErrLines, Consumer<Ebur128StrErrFilterEvent> ebur128EventConsumer, Consumer<RawStdErrFilterEvent> rawStdErrEventConsumer) {
        LavfiMetadataFilterParser lavfiMetadataFilterParser = new LavfiMetadataFilterParser();
        stdOutLines.forEach(lavfiMetadataFilterParser::addLavfiRawLine);
        RawStdErrEventParser rawStdErrEventParser = new RawStdErrEventParser(event -> {
            if (event.getFilterName().equals("ebur128")) {
                ebur128EventConsumer.accept(new Ebur128StrErrFilterEvent(event.getLineValue()));
            } else {
                rawStdErrEventConsumer.accept((RawStdErrFilterEvent)event);
            }
        });
        stdErrLines.forEach(rawStdErrEventParser::onLine);
        return new MediaAnalyserResult(lavfiMetadataFilterParser.close(), rawStdErrEventParser.close(), Set.of());
    }

    public void extract(Consumer<String> sysOut, Consumer<String> sysErr) {
        FFmpeg ffmpeg = this.prepareFFmpeg();
        CircularFifoQueue stdErrLinesBucket = new CircularFifoQueue(10);
        ProcesslauncherLifecycle processLifecycle = ffmpeg.execute(this.mediaAnalyser.getExecutableFinder(), lineEntry -> {
            String line = lineEntry.getLine();
            log.trace("Line: {}", (Object)line);
            if (!lineEntry.isStdErr()) {
                sysOut.accept(line);
            } else {
                sysErr.accept(line);
                stdErrLinesBucket.add((Object)line.trim());
            }
        });
        log.debug("Start {}", (Object)processLifecycle.getLauncher().getFullCommandLine());
        processLifecycle.waitForEnd();
        boolean execOk = processLifecycle.isCorrectlyDone();
        if (!execOk) {
            String stdErr = stdErrLinesBucket.stream().collect(Collectors.joining("|"));
            throw new InvalidExecution(processLifecycle, stdErr);
        }
    }

    public String getSource() {
        return this.source;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String toString() {
        if (this.source != null) {
            return this.source;
        }
        return this.sourceFile.getPath();
    }

    public List<AudioFilterSupplier> getAudioFilters() {
        return this.audioFilters.stream().filter(f -> !f.toFilter().getFilterName().equals("ametadata")).toList();
    }

    public List<VideoFilterSupplier> getVideoFilters() {
        return this.videoFilters.stream().filter(f -> !f.toFilter().getFilterName().equals("metadata")).toList();
    }
}

