/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import tv.hd3g.fflauncher.FFbase;

class BaseAnalyserSession {
    private Duration maxExecTime;
    private ScheduledExecutorService maxExecTimeScheduler;

    BaseAnalyserSession() {
    }

    public boolean setMaxExecutionTime(Duration maxExecTime, ScheduledExecutorService maxExecTimeScheduler) {
        if (maxExecTime.getSeconds() <= 0L) {
            return false;
        }
        this.maxExecTime = maxExecTime;
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
        return true;
    }

    protected void applyMaxExecTime(FFbase ffbase) {
        if (this.maxExecTimeScheduler == null) {
            return;
        }
        ffbase.setMaxExecTimeScheduler(this.maxExecTimeScheduler);
        ffbase.setMaxExecutionTimeForShortCommands(this.maxExecTime.toSeconds(), TimeUnit.SECONDS);
    }
}

