/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.lavfimtd;

import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdAstats;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdAstatsChannel;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdCropdetect;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdEvent;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdEventFrameDef;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdEventFrameType;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdIdet;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdIdetFrame;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdIdetRepeatedFrame;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdIdetRepeatedFrameType;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdIdetSingleFrameType;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdPosition;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdSiti;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdSitiSummary;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdValue;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;

public class LavfiMetadataFilterParser {
    private static final Logger log = LoggerFactory.getLogger(LavfiMetadataFilterParser.class);
    public static final String DEFAULT_KEY = "default";
    private static final String SUFFIX_END = "_end";
    private static final String SUFFIX_START = "_start";
    private final List<String> bucket = new ArrayList<String>();
    private final List<Map<String, Map<String, String>>> rawEvents = new ArrayList<Map<String, Map<String, String>>>();
    private LavfiMtdPosition currentPosition;
    private final List<LavfiMtdValue<Float>> aPhaseMeterReport = new ArrayList<LavfiMtdValue<Float>>();
    private final List<LavfiMtdValue<LavfiMtdAstats>> aStatsReport = new ArrayList<LavfiMtdValue<LavfiMtdAstats>>();
    private final List<LavfiMtdValue<Float>> blockDetectReport = new ArrayList<LavfiMtdValue<Float>>();
    private final List<LavfiMtdValue<Float>> blurDetectReport = new ArrayList<LavfiMtdValue<Float>>();
    private final List<LavfiMtdValue<LavfiMtdCropdetect>> cropDetectReport = new ArrayList<LavfiMtdValue<LavfiMtdCropdetect>>();
    private final List<LavfiMtdValue<LavfiMtdIdet>> idetReport = new ArrayList<LavfiMtdValue<LavfiMtdIdet>>();
    private final List<LavfiMtdValue<LavfiMtdSiti>> sitiReport = new ArrayList<LavfiMtdValue<LavfiMtdSiti>>();
    private final List<LavfiMtdEvent> monoEvents = new ArrayList<LavfiMtdEvent>();
    private final List<LavfiMtdEvent> freezeEvents = new ArrayList<LavfiMtdEvent>();
    private final List<LavfiMtdEvent> silenceEvents = new ArrayList<LavfiMtdEvent>();
    private final List<LavfiMtdEvent> blackEvents = new ArrayList<LavfiMtdEvent>();

    public void addLavfiRawLine(String rawLine) {
        log.trace("Lavfi line: {}", (Object)rawLine);
        if (rawLine.startsWith("frame:")) {
            if (this.currentPosition == null) {
                this.currentPosition = LavfiMetadataFilterParser.parseFrameLine(rawLine);
                return;
            }
            this.completeFrame();
            this.currentPosition = LavfiMetadataFilterParser.parseFrameLine(rawLine);
        } else {
            if (this.currentPosition == null) {
                throw new IllegalArgumentException("Missing frame declaration: " + rawLine);
            }
            if (rawLine.startsWith("lavfi.")) {
                this.bucket.add(rawLine);
            } else {
                log.debug("Can't manage lavfi line content inside frame (ignore it): {}", (Object)rawLine);
            }
        }
    }

    public LavfiMetadataFilterParser close() {
        if (!this.bucket.isEmpty() && this.currentPosition != null) {
            this.completeFrame();
            this.currentPosition = null;
        }
        this.extractEvents();
        return this;
    }

    public int getReportCount() {
        return this.aPhaseMeterReport.size() + this.aStatsReport.size() + this.blockDetectReport.size() + this.blurDetectReport.size() + this.cropDetectReport.size() + this.idetReport.size() + this.sitiReport.size();
    }

    public int getEventCount() {
        return this.monoEvents.size() + this.freezeEvents.size() + this.silenceEvents.size() + this.blackEvents.size();
    }

    static LavfiMtdPosition parseFrameLine(String line) {
        List<String> items = MediaAnalyser.splitter(line, ' ');
        return new LavfiMtdPosition(MediaAnalyser.assertAndParse(items.get(0), "frame:", Integer::valueOf), MediaAnalyser.assertAndParse(items.get(1), "pts:", Long::valueOf), MediaAnalyser.assertAndParse(items.get(2), "pts_time:", Float::valueOf).floatValue());
    }

    private void completeFrame() {
        HashMap rawFrame = this.bucket.stream().map(line -> MediaAnalyser.assertAndParse(line, "lavfi.")).toList().stream().collect(Collectors.groupingBy(line -> MediaAnalyser.splitter(MediaAnalyser.splitter(line, '.', 1).get(0), '=', 1).get(0), HashMap::new, Collectors.mapping(line -> MediaAnalyser.splitter(line, '='), Collectors.toMap(line -> {
            String kv = (String)line.get(0);
            int pos = kv.indexOf(".");
            if (pos == -1) {
                return DEFAULT_KEY;
            }
            return kv.substring(pos + 1);
        }, line -> (String)line.get(1)))));
        rawFrame.entrySet().forEach(entry -> this.extractMetadatas((String)entry.getKey(), (Map)entry.getValue()));
        boolean frameContainEvent = rawFrame.entrySet().stream().anyMatch(rf -> {
            String filterName = (String)rf.getKey();
            if (filterName.contains(SUFFIX_START) || filterName.contains(SUFFIX_END)) {
                return true;
            }
            return ((Map)rf.getValue()).keySet().stream().anyMatch(k -> k.contains(SUFFIX_START) || k.contains(SUFFIX_END));
        });
        if (frameContainEvent) {
            this.rawEvents.add(rawFrame.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        this.bucket.clear();
    }

    private static int parseInt(String floatString) {
        return Math.round(Float.parseFloat(floatString));
    }

    private static long parseLong(String doubleString) {
        return Math.round(Double.parseDouble(doubleString));
    }

    private <T> LavfiMtdValue<T> toMtdValue(T value) {
        return new LavfiMtdValue<T>(this.currentPosition.frame(), this.currentPosition.pts(), this.currentPosition.ptsTime(), value);
    }

    private void extractMetadatas(String filterName, Map<String, String> rawFrames) {
        switch (filterName) {
            case "aphasemeter": {
                this.extractMetadataFloat("phase", rawFrames, this.aPhaseMeterReport);
                break;
            }
            case "astats": {
                LavfiMetadataFilterParser.extractAstats(rawFrames).ifPresent(value -> this.aStatsReport.add(this.toMtdValue(value)));
                break;
            }
            case "block": {
                this.extractMetadataFloat(DEFAULT_KEY, rawFrames, this.blockDetectReport);
                break;
            }
            case "blur": {
                this.extractMetadataFloat(DEFAULT_KEY, rawFrames, this.blurDetectReport);
                break;
            }
            case "cropdetect": {
                LavfiMetadataFilterParser.extractCropdetect(rawFrames).ifPresent(value -> this.cropDetectReport.add(this.toMtdValue(value)));
                break;
            }
            case "idet": {
                LavfiMetadataFilterParser.extractIdet(rawFrames).ifPresent(value -> this.idetReport.add(this.toMtdValue(value)));
                break;
            }
            case "siti": {
                LavfiMetadataFilterParser.extractSiti(rawFrames).ifPresent(value -> this.sitiReport.add(this.toMtdValue(value)));
                break;
            }
            default: {
                if (filterName.contains(SUFFIX_START) || filterName.contains(SUFFIX_END) || filterName.contains("_duration") || rawFrames.keySet().stream().anyMatch(f -> f.contains(SUFFIX_START) || f.contains(SUFFIX_END) || f.contains("_duration"))) {
                    return;
                }
                log.warn("Can't manage filter value {}: {} [{}]", new Object[]{filterName, rawFrames, this.currentPosition});
            }
        }
    }

    private void extractEvents() {
        this.importEventsForFilter("aphasemeter", "mono", "mono", this.monoEvents);
        this.importEventsForFilter("freezedetect", "freeze", "freeze", this.freezeEvents);
        this.importEventsForFilter("silence", DEFAULT_KEY, "silence", this.silenceEvents);
        this.importEventsForFilter("black", DEFAULT_KEY, "black", this.blackEvents);
        this.rawEvents.clear();
    }

    private void extractMetadataFloat(String keyName, Map<String, String> rawFrames, List<LavfiMtdValue<Float>> toAdd) {
        Optional.ofNullable(rawFrames.get(keyName)).map(LavfiMetadataFilterParser::parseFloat).ifPresent(value -> toAdd.add(this.toMtdValue(value)));
    }

    public static float parseFloat(String value) {
        if (value == null || value.isBlank() || value.equalsIgnoreCase("nan")) {
            return Float.NaN;
        }
        if (value.equalsIgnoreCase("-inf")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (value.equalsIgnoreCase("inf")) {
            return Float.POSITIVE_INFINITY;
        }
        return Float.valueOf(value).floatValue();
    }

    private static Optional<LavfiMtdAstats> extractAstats(Map<String, String> rawFrames) {
        ArrayList channelsContent = new ArrayList();
        rawFrames.entrySet().forEach(entry -> {
            String keyLine = (String)entry.getKey();
            int channelId = Integer.valueOf(keyLine.substring(0, keyLine.indexOf("."))) - 1;
            String key = keyLine.substring(keyLine.indexOf(".") + 1, keyLine.length());
            while (channelId >= channelsContent.size()) {
                channelsContent.add(new HashMap());
            }
            ((Map)channelsContent.get(channelId)).put(key, (String)entry.getValue());
        });
        List<LavfiMtdAstatsChannel> channels = channelsContent.stream().map(content -> {
            Float dcOffset = Optional.ofNullable((String)content.remove("DC_offset")).map(LavfiMetadataFilterParser::parseFloat).orElse(Float.valueOf(Float.NaN));
            Float peakLevel = Optional.ofNullable((String)content.remove("Peak_level")).map(LavfiMetadataFilterParser::parseFloat).orElse(Float.valueOf(Float.NaN));
            Float flatFactor = Optional.ofNullable((String)content.remove("Flat_factor")).map(LavfiMetadataFilterParser::parseFloat).orElse(Float.valueOf(Float.NaN));
            Long peakCount = Optional.ofNullable((String)content.remove("Peak_count")).map(LavfiMetadataFilterParser::parseLong).orElse(0L);
            Float noiseFloor = Optional.ofNullable((String)content.remove("Noise_floor")).map(LavfiMetadataFilterParser::parseFloat).orElse(Float.valueOf(Float.NaN));
            Long noiseFloorCount = Optional.ofNullable((String)content.remove("Noise_floor_count")).map(LavfiMetadataFilterParser::parseLong).orElse(0L);
            Float entropy = Optional.ofNullable((String)content.remove("Entropy")).map(LavfiMetadataFilterParser::parseFloat).orElse(Float.valueOf(Float.NaN));
            Map<String, Float> other = content.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> Float.valueOf(LavfiMetadataFilterParser.parseFloat((String)entry.getValue()))));
            return new LavfiMtdAstatsChannel(dcOffset.floatValue(), peakLevel.floatValue(), flatFactor.floatValue(), peakCount, noiseFloor.floatValue(), noiseFloorCount, entropy.floatValue(), other);
        }).toList();
        if (channels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(new LavfiMtdAstats(channels));
    }

    private static Optional<LavfiMtdCropdetect> extractCropdetect(Map<String, String> rawFrames) {
        try {
            int x1 = Integer.parseInt(rawFrames.get("x1"));
            int x2 = Integer.parseInt(rawFrames.get("x2"));
            int y1 = Integer.parseInt(rawFrames.get("y1"));
            int y2 = Integer.parseInt(rawFrames.get("y2"));
            int w = Integer.parseInt(rawFrames.get("w"));
            int h = Integer.parseInt(rawFrames.get("h"));
            int x = Integer.parseInt(rawFrames.get("x"));
            int y = Integer.parseInt(rawFrames.get("y"));
            return Optional.ofNullable(new LavfiMtdCropdetect(x1, x2, y1, y2, w, h, x, y));
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private static Optional<LavfiMtdIdet> extractIdet(Map<String, String> rawFrames) {
        try {
            LavfiMtdIdetFrame single = new LavfiMtdIdetFrame(LavfiMtdIdetSingleFrameType.valueOf(rawFrames.get("single.current_frame").toUpperCase()), LavfiMetadataFilterParser.parseInt(rawFrames.get("single.tff")), LavfiMetadataFilterParser.parseInt(rawFrames.get("single.bff")), LavfiMetadataFilterParser.parseInt(rawFrames.get("single.progressive")), LavfiMetadataFilterParser.parseInt(rawFrames.get("single.undetermined")));
            LavfiMtdIdetFrame multiple = new LavfiMtdIdetFrame(LavfiMtdIdetSingleFrameType.valueOf(rawFrames.get("multiple.current_frame").toUpperCase()), LavfiMetadataFilterParser.parseInt(rawFrames.get("multiple.tff")), LavfiMetadataFilterParser.parseInt(rawFrames.get("multiple.bff")), LavfiMetadataFilterParser.parseInt(rawFrames.get("multiple.progressive")), LavfiMetadataFilterParser.parseInt(rawFrames.get("multiple.undetermined")));
            LavfiMtdIdetRepeatedFrame repeated = new LavfiMtdIdetRepeatedFrame(LavfiMtdIdetRepeatedFrameType.valueOf(rawFrames.get("repeated.current_frame").toUpperCase()), LavfiMetadataFilterParser.parseInt(rawFrames.get("repeated.neither")), LavfiMetadataFilterParser.parseInt(rawFrames.get("repeated.top")), LavfiMetadataFilterParser.parseInt(rawFrames.get("repeated.bottom")));
            return Optional.ofNullable(new LavfiMtdIdet(single, multiple, repeated));
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private static Optional<LavfiMtdSiti> extractSiti(Map<String, String> rawFrames) {
        String si = rawFrames.get("si");
        String ti = rawFrames.get("ti");
        if (si == null || ti == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(new LavfiMtdSiti(Float.valueOf(si).floatValue(), Float.valueOf(ti).floatValue()));
    }

    private void importEventsForFilter(String lavfiMtdFilterKeyName, String lavfiMtdKeyName, String eventsNameToSet, List<LavfiMtdEvent> listToAddResult) {
        listToAddResult.addAll(this.rawEvents.stream().filter(entries -> {
            Set itemKeys = entries.keySet();
            if (itemKeys.contains(lavfiMtdFilterKeyName)) {
                Set subItemKeys = ((Map)entries.get(lavfiMtdFilterKeyName)).keySet();
                return subItemKeys.contains(lavfiMtdKeyName + SUFFIX_START) || subItemKeys.contains(lavfiMtdKeyName + SUFFIX_END);
            }
            return itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_START) || itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_END);
        }).flatMap(entries -> {
            Set itemKeys = entries.keySet();
            if (itemKeys.contains(lavfiMtdFilterKeyName)) {
                return Stream.of(this.mapStyle0(lavfiMtdFilterKeyName, lavfiMtdKeyName, (Map<String, Map<String, String>>)entries));
            }
            if (itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_START)) {
                return this.mapStyle1(lavfiMtdFilterKeyName + SUFFIX_START, lavfiMtdKeyName, (Map<String, Map<String, String>>)entries, LavfiMtdEventFrameType.START);
            }
            if (itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_END)) {
                return this.mapStyle1(lavfiMtdFilterKeyName + SUFFIX_END, lavfiMtdKeyName, (Map<String, Map<String, String>>)entries, LavfiMtdEventFrameType.END);
            }
            throw new IllegalStateException("Can't extract to event: " + entries);
        }).reduce(new ArrayList(0), (list, frameDef) -> {
            if (frameDef.type() == LavfiMtdEventFrameType.START) {
                list.add(new LavfiMtdEvent(eventsNameToSet, frameDef.scope(), Float.valueOf(frameDef.time()).floatValue(), Float.NaN));
            } else {
                int lastPos = LavfiMetadataFilterParser.reverseSearch(list, eventsNameToSet, frameDef.scope());
                if (lastPos == -1) {
                    log.warn("Can't found start event for {}/{}", (Object)eventsNameToSet, frameDef);
                    return list;
                }
                LavfiMtdEvent previousStart = (LavfiMtdEvent)list.get(lastPos);
                list.set(lastPos, new LavfiMtdEvent(eventsNameToSet, frameDef.scope(), previousStart.start(), Float.valueOf(frameDef.time()).floatValue()));
            }
            return list;
        }, (l, r) -> {
            l.addAll(r);
            return l;
        }));
    }

    private LavfiMtdEventFrameDef mapStyle0(String lavfiMtdFilterKeyName, String lavfiMtdKeyName, Map<String, Map<String, String>> entries) {
        Map<String, String> subEntry = entries.get(lavfiMtdFilterKeyName);
        if (subEntry.containsKey(lavfiMtdKeyName + SUFFIX_START)) {
            return new LavfiMtdEventFrameDef(LavfiMtdEventFrameType.START, null, subEntry.get(lavfiMtdKeyName + SUFFIX_START));
        }
        if (subEntry.containsKey(lavfiMtdKeyName + SUFFIX_END)) {
            return new LavfiMtdEventFrameDef(LavfiMtdEventFrameType.END, null, subEntry.get(lavfiMtdKeyName + SUFFIX_END));
        }
        throw new IllegalStateException("Can't extract to event (mapStyle0): " + lavfiMtdFilterKeyName + ", " + lavfiMtdKeyName + ", " + entries);
    }

    private Stream<LavfiMtdEventFrameDef> mapStyle1(String keyName, String lavfiMtdKeyName, Map<String, Map<String, String>> entries, LavfiMtdEventFrameType type) {
        Map<String, String> subEntry = entries.get(keyName);
        if (subEntry.containsKey(lavfiMtdKeyName)) {
            return Stream.of(new LavfiMtdEventFrameDef(type, null, subEntry.get(lavfiMtdKeyName)));
        }
        return subEntry.entrySet().stream().map(entry -> new LavfiMtdEventFrameDef(type, (String)entry.getKey(), (String)entry.getValue()));
    }

    private static final int reverseSearch(List<LavfiMtdEvent> list, String searchName, String searchScope) {
        for (int pos = list.size() - 1; pos >= 0; --pos) {
            LavfiMtdEvent entry = list.get(pos);
            if (!entry.name().equals(searchName) || entry.scope() != null && !entry.scope().equals(searchScope)) continue;
            return pos;
        }
        return -1;
    }

    public LavfiMtdSitiSummary computeSitiStats() {
        DoubleSummaryStatistics si = this.sitiReport.stream().map(LavfiMtdValue::value).mapToDouble(LavfiMtdSiti::si).summaryStatistics();
        DoubleSummaryStatistics ti = this.sitiReport.stream().map(LavfiMtdValue::value).mapToDouble(LavfiMtdSiti::ti).summaryStatistics();
        return new LavfiMtdSitiSummary(si, ti);
    }

    public List<LavfiMtdValue<Float>> getAPhaseMeterReport() {
        return this.aPhaseMeterReport;
    }

    public List<LavfiMtdValue<LavfiMtdAstats>> getAStatsReport() {
        return this.aStatsReport;
    }

    public List<LavfiMtdValue<Float>> getBlockDetectReport() {
        return this.blockDetectReport;
    }

    public List<LavfiMtdValue<Float>> getBlurDetectReport() {
        return this.blurDetectReport;
    }

    public List<LavfiMtdValue<LavfiMtdCropdetect>> getCropDetectReport() {
        return this.cropDetectReport;
    }

    public List<LavfiMtdValue<LavfiMtdIdet>> getIdetReport() {
        return this.idetReport;
    }

    public List<LavfiMtdValue<LavfiMtdSiti>> getSitiReport() {
        return this.sitiReport;
    }

    public List<LavfiMtdEvent> getMonoEvents() {
        return this.monoEvents;
    }

    public List<LavfiMtdEvent> getFreezeEvents() {
        return this.freezeEvents;
    }

    public List<LavfiMtdEvent> getSilenceEvents() {
        return this.silenceEvents;
    }

    public List<LavfiMtdEvent> getBlackEvents() {
        return this.blackEvents;
    }
}

