/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.awt.Point;
import java.util.Optional;
import java.util.Set;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.Filter;

public class AudioFilterEbur128
implements AudioFilterSupplier {
    private boolean video;
    private Point size;
    private int meter = -1;
    private boolean metadata;
    private Framelog framelog;
    private Set<Peak> peakMode;
    private boolean dualmono;
    private float panlaw = Float.MIN_VALUE;
    private int target = Integer.MIN_VALUE;
    private Gauge gauge;
    private Scale scale;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("ebur128");
        f.addOptionalArgument("video", this.video, "1");
        f.addArgument("size", Optional.ofNullable(this.size).map(s -> s.x + "x" + s.y));
        f.addOptionalNonNegativeArgument("meter", this.meter);
        f.addOptionalArgument("metadata", this.metadata, "1");
        f.addOptionalArgument("dualmono", this.dualmono, "true");
        f.addOptionalArgument("target", this.target > Integer.MIN_VALUE, String.valueOf(this.target));
        f.addOptionalArgument("framelog", this.framelog);
        f.addOptionalArgument("gauge", this.gauge);
        f.addOptionalArgument("scale", this.scale);
        f.addOptionalArgument("panlaw", this.panlaw > Float.MIN_VALUE, String.valueOf(this.panlaw));
        if (this.peakMode != null) {
            f.addArgument("peak", this.peakMode, "+");
        }
        return f;
    }

    public boolean isVideo() {
        return this.video;
    }

    public Point getSize() {
        return this.size;
    }

    public int getMeter() {
        return this.meter;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public Framelog getFramelog() {
        return this.framelog;
    }

    public Set<Peak> getPeakMode() {
        return this.peakMode;
    }

    public boolean isDualmono() {
        return this.dualmono;
    }

    public float getPanlaw() {
        return this.panlaw;
    }

    public int getTarget() {
        return this.target;
    }

    public Gauge getGauge() {
        return this.gauge;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setVideo(boolean video) {
        this.video = video;
    }

    public void setSize(Point size) {
        this.size = size;
    }

    public void setMeter(int meter) {
        this.meter = meter;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public void setFramelog(Framelog framelog) {
        this.framelog = framelog;
    }

    public void setPeakMode(Set<Peak> peakMode) {
        this.peakMode = peakMode;
    }

    public void setDualmono(boolean dualmono) {
        this.dualmono = dualmono;
    }

    public void setPanlaw(float panlaw) {
        this.panlaw = panlaw;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void setGauge(Gauge gauge) {
        this.gauge = gauge;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioFilterEbur128)) {
            return false;
        }
        AudioFilterEbur128 other = (AudioFilterEbur128)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVideo() != other.isVideo()) {
            return false;
        }
        if (this.getMeter() != other.getMeter()) {
            return false;
        }
        if (this.isMetadata() != other.isMetadata()) {
            return false;
        }
        if (this.isDualmono() != other.isDualmono()) {
            return false;
        }
        if (Float.compare(this.getPanlaw(), other.getPanlaw()) != 0) {
            return false;
        }
        if (this.getTarget() != other.getTarget()) {
            return false;
        }
        Point this$size = this.getSize();
        Point other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Framelog this$framelog = this.getFramelog();
        Framelog other$framelog = other.getFramelog();
        if (this$framelog == null ? other$framelog != null : !((Object)((Object)this$framelog)).equals((Object)other$framelog)) {
            return false;
        }
        Set<Peak> this$peakMode = this.getPeakMode();
        Set<Peak> other$peakMode = other.getPeakMode();
        if (this$peakMode == null ? other$peakMode != null : !((Object)this$peakMode).equals(other$peakMode)) {
            return false;
        }
        Gauge this$gauge = this.getGauge();
        Gauge other$gauge = other.getGauge();
        if (this$gauge == null ? other$gauge != null : !((Object)((Object)this$gauge)).equals((Object)other$gauge)) {
            return false;
        }
        Scale this$scale = this.getScale();
        Scale other$scale = other.getScale();
        return !(this$scale == null ? other$scale != null : !((Object)((Object)this$scale)).equals((Object)other$scale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioFilterEbur128;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVideo() ? 79 : 97);
        result = result * 59 + this.getMeter();
        result = result * 59 + (this.isMetadata() ? 79 : 97);
        result = result * 59 + (this.isDualmono() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getPanlaw());
        result = result * 59 + this.getTarget();
        Point $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Framelog $framelog = this.getFramelog();
        result = result * 59 + ($framelog == null ? 43 : ((Object)((Object)$framelog)).hashCode());
        Set<Peak> $peakMode = this.getPeakMode();
        result = result * 59 + ($peakMode == null ? 43 : ((Object)$peakMode).hashCode());
        Gauge $gauge = this.getGauge();
        result = result * 59 + ($gauge == null ? 43 : ((Object)((Object)$gauge)).hashCode());
        Scale $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)((Object)$scale)).hashCode());
        return result;
    }

    public String toString() {
        return "AudioFilterEbur128(video=" + this.isVideo() + ", size=" + this.getSize() + ", meter=" + this.getMeter() + ", metadata=" + this.isMetadata() + ", framelog=" + this.getFramelog() + ", peakMode=" + this.getPeakMode() + ", dualmono=" + this.isDualmono() + ", panlaw=" + this.getPanlaw() + ", target=" + this.getTarget() + ", gauge=" + this.getGauge() + ", scale=" + this.getScale() + ")";
    }

    public static enum Framelog {
        QUIET,
        INFO,
        VERBOSE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Gauge {
        MOMENTARY,
        SHORTTERM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Scale {
        ABSOLUTE,
        RELATIVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Peak {
        NONE,
        SAMPLE,
        TRUE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

