/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.List;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.FilterArgument;

public class AudioFilterChannelsplit
implements AudioFilterSupplier {
    private final ChannelLayout sourceChannelLayout;
    private final List<Channel> sourceChannelList;
    private final List<Channel> selectedChannels;

    public AudioFilterChannelsplit(ChannelLayout sourceChannelLayout, List<Channel> selectedChannels) {
        this.sourceChannelLayout = sourceChannelLayout;
        this.selectedChannels = selectedChannels;
        this.sourceChannelList = sourceChannelLayout.getChannelList();
        if (!selectedChannels.stream().allMatch(this.sourceChannelList::contains)) {
            throw new IllegalArgumentException("Invalid selected channel(s) from source. You can choose only on " + this.sourceChannelList);
        }
    }

    @Override
    public Filter toFilter() {
        return new Filter("channelsplit", new FilterArgument("channel_layout", this.sourceChannelLayout), new FilterArgument("channels", this.selectedChannels, "+"));
    }
}

