/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.ffprobecontainer;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public interface SAXAttributeParserTraits {
    public static final Logger log = LoggerFactory.getLogger(SAXAttributeParserTraits.class);

    default public Optional<String> getAttrValue(Attributes attributes, String keyName) {
        return Optional.ofNullable(attributes.getValue(keyName));
    }

    default public String getAttrValue(Attributes attributes, String keyName, String orDefault) {
        return this.getAttrValue(attributes, keyName).orElse(orDefault);
    }

    default public Optional<Boolean> getAttrBooleanValue(Attributes attributes, String keyName) {
        return this.getAttrValue(attributes, keyName).map(v -> v.equals("1"));
    }

    default public boolean getAttrBooleanValue(Attributes attributes, String keyName, boolean orDefault) {
        return this.getAttrBooleanValue(attributes, keyName).orElse(orDefault);
    }

    default public Optional<Integer> getAttrIntValue(Attributes attributes, String keyName) {
        return this.getAttrValue(attributes, keyName).flatMap(v -> {
            try {
                return Optional.ofNullable(Integer.valueOf(v));
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse number: {}", v);
                return Optional.empty();
            }
        });
    }

    default public int getAttrIntValue(Attributes attributes, String keyName, int orDefault) {
        return this.getAttrIntValue(attributes, keyName).orElse(orDefault);
    }

    default public Optional<Long> getAttrLongValue(Attributes attributes, String keyName) {
        return this.getAttrValue(attributes, keyName).flatMap(v -> {
            try {
                return Optional.ofNullable(Long.valueOf(v));
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse number: {}", v);
                return Optional.empty();
            }
        });
    }

    default public long getAttrLongValue(Attributes attributes, String keyName, long orDefault) {
        return this.getAttrLongValue(attributes, keyName).orElse(orDefault);
    }

    default public Optional<Float> getAttrFloatValue(Attributes attributes, String keyName) {
        return this.getAttrValue(attributes, keyName).flatMap(v -> {
            try {
                return Optional.ofNullable(Float.valueOf(v));
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse number: {}", v);
                return Optional.empty();
            }
        });
    }

    default public float getAttrFloatValue(Attributes attributes, String keyName, float orDefault) {
        return this.getAttrFloatValue(attributes, keyName).orElse(Float.valueOf(orDefault)).floatValue();
    }
}

