/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.acm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import tv.hd3g.fflauncher.acm.ACMListIndexPositionHandler;
import tv.hd3g.fflauncher.acm.InputAudioStream;
import tv.hd3g.fflauncher.acm.OutputAudioStream;
import tv.hd3g.fflauncher.enums.Channel;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.filtering.AudioFilterChannelmap;
import tv.hd3g.fflauncher.filtering.Filter;

class ACMRemapDefinitionFilter
extends ACMListIndexPositionHandler {
    private final OutputAudioStream outputAudioStream;
    private final InputAudioStream inputAudioStream;

    ACMRemapDefinitionFilter(InputAudioStream inputAudioStream, OutputAudioStream outputAudioStream) {
        this.inputAudioStream = Objects.requireNonNull(inputAudioStream);
        this.outputAudioStream = Objects.requireNonNull(outputAudioStream);
        boolean notSameSource = outputAudioStream.getChannels().stream().anyMatch(c -> !c.getInputAudioStream().equals(inputAudioStream));
        if (notSameSource) {
            throw new IllegalArgumentException("Can't merge source streams for remap, outputs must only take from: " + inputAudioStream);
        }
        if (inputAudioStream.getLayout().getChannelSize() != outputAudioStream.getLayout().getChannelSize()) {
            throw new IllegalArgumentException("Incompablity layouts size with input (" + inputAudioStream.getLayout().getChannelSize() + ") and output (" + outputAudioStream.getLayout().getChannelSize() + ")");
        }
    }

    @Override
    public OutputAudioStream getLinkableOutStreamReference() {
        return this.outputAudioStream;
    }

    @Override
    public String toMapReferenceAsInput() {
        return "remap" + this.absolutePosIndex;
    }

    public Filter toFilter() {
        ChannelLayout sourceLayout = this.inputAudioStream.getLayout();
        ChannelLayout destLayout = this.outputAudioStream.getLayout();
        Map<Channel, Channel> map = this.outputAudioStream.getChannels().stream().collect(Collectors.toUnmodifiableMap(outChannel -> destLayout.getChannelList().get(outChannel.getChOutIndex().getPosInStream()), outChannel -> sourceLayout.getChannelList().get(outChannel.getChInIndex().getPosInStream())));
        Filter filter = new AudioFilterChannelmap(destLayout, map).toFilter();
        filter.setSourceBlocks(List.of(this.inputAudioStream.toMapReferenceAsInput()));
        filter.setDestBlocks(List.of(this.toMapReferenceAsInput()));
        return filter;
    }
}

