/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.progress;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ProgressBlock {
    private final Map<String, String> items;

    ProgressBlock(List<String> lines) {
        int countTo = lines.get(lines.size() - 1).startsWith("progress=") ? lines.size() - 1 : lines.size();
        int lastIndexOfProgress = IntStream.range(0, countTo).filter(pos -> ((String)lines.get(pos)).startsWith("progress=")).reduce((l, r) -> r).orElse(-1);
        this.items = lines.stream().skip((long)lastIndexOfProgress + 1L).collect(Collectors.toUnmodifiableMap(this::splitLeft, this::splitRight));
    }

    private String splitLeft(String line) {
        int pos = line.indexOf("=");
        if (pos < 1) {
            throw new IllegalArgumentException("Invalid entry: \"" + line + "\"");
        }
        return line.substring(0, pos);
    }

    private String splitRight(String line) {
        int pos = line.indexOf("=");
        if (pos + 1 == line.length()) {
            throw new IllegalArgumentException("Invalid entry: \"" + line + "\"");
        }
        return line.substring(pos + 1, line.length());
    }

    public boolean isEnd() {
        return this.items.getOrDefault("progress", "continue").equals("end");
    }

    public Optional<Integer> getFrame() {
        return Optional.ofNullable(this.items.get("frame")).map(Integer::valueOf);
    }

    public Optional<Float> getFPS() {
        return Optional.ofNullable(this.items.get("fps")).map(Float::valueOf);
    }

    public Optional<Float> getBitrate() {
        return Optional.ofNullable(this.items.get("bitrate")).filter(b -> !b.equalsIgnoreCase("N/A")).map(Float::valueOf);
    }

    public Optional<Long> getTotalSize() {
        return Optional.ofNullable(this.items.get("total_size")).filter(b -> !b.equalsIgnoreCase("N/A")).map(Long::valueOf);
    }

    public int getDupFrames() {
        return Integer.valueOf(this.items.getOrDefault("dup_frames", "0"));
    }

    public int getDropFrames() {
        return Integer.valueOf(this.items.getOrDefault("drop_frames", "0"));
    }

    public Float getSpeedX() {
        String speed = this.items.getOrDefault("speed", "0");
        if (speed.toLowerCase().endsWith("x")) {
            return Float.valueOf(speed.substring(0, speed.length() - 1));
        }
        return Float.valueOf(speed);
    }

    public long getOutTimeUs() {
        return Long.valueOf(this.items.getOrDefault("out_time_us", "0"));
    }

    public long getOutTimeMs() {
        return Long.valueOf(this.items.getOrDefault("out_time_ms", "0"));
    }

    public Duration getOutTimeDuration() {
        return Duration.ofMillis(Long.valueOf(this.items.getOrDefault("out_time_us", "0")) / 1000L);
    }

    public String getOutTime() {
        return this.items.getOrDefault("out_time", "00:00:00.000000");
    }

    public Map<String, Float> getStreamQ() {
        return this.items.keySet().stream().filter(k -> k.startsWith("stream_")).map(k -> new EntryStreamQ((String)k, this.items.get(k))).collect(Collectors.toUnmodifiableMap(EntryStreamQ::k, EntryStreamQ::v));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProgressBlock [items=");
        builder.append(this.items);
        builder.append("]");
        return builder.toString();
    }

    private record EntryStreamQ(String k, Float v) {
        public EntryStreamQ(String k, String v) {
            this(k.substring("stream_".length(), k.lastIndexOf("_")), Float.valueOf(v));
        }
    }
}

