/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.progress;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicLatchReference<T> {
    private static final String CAN_T_WAIT_THE_AVAILABILITY_OF_OBJECT_REFERENCE = "Can't wait the availability of object reference";
    private final AtomicReference<T> reference = new AtomicReference();
    private final CountDownLatch latchReady = new CountDownLatch(1);

    public void set(T object) {
        this.reference.set(object);
        this.latchReady.countDown();
    }

    public T get(long timeout, TimeUnit unit) {
        try {
            if (!this.latchReady.await(timeout, unit)) {
                throw new IllegalStateException(CAN_T_WAIT_THE_AVAILABILITY_OF_OBJECT_REFERENCE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(CAN_T_WAIT_THE_AVAILABILITY_OF_OBJECT_REFERENCE, e);
        }
        return this.reference.get();
    }

    public <E extends Throwable> void get(long timeout, TimeUnit unit, ConsumerWithException<T, E> ifAvailable) throws E {
        try {
            if (!this.latchReady.await(timeout, unit)) {
                return;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(CAN_T_WAIT_THE_AVAILABILITY_OF_OBJECT_REFERENCE, e);
        }
        ifAvailable.accept(this.reference.get());
    }

    public static interface ConsumerWithException<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }
}

