/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tv.hd3g.fflauncher.filtering.parser.FilterParserBaseChainFilter;
import tv.hd3g.fflauncher.filtering.parser.FilterParserChars;
import tv.hd3g.fflauncher.filtering.parser.FilterParserFilter;

class FilterParserChain
extends FilterParserBaseChainFilter {
    private static final String INVALID_MISSING = "Invalid ], missing [ in ";

    FilterParserChain(List<FilterParserChars> content) {
        super(content);
    }

    FilterParserChain(String content) {
        super(content);
    }

    List<String> getSourceBlocks() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder captured = null;
        for (int pos = 0; pos < this.content.size(); ++pos) {
            FilterParserChars current = (FilterParserChars)this.content.get(pos);
            if (current.isBracketOpen()) {
                captured = new StringBuilder();
                continue;
            }
            if (current.isBracketClose()) {
                if (captured != null) {
                    list.add(captured.toString());
                    captured = null;
                    continue;
                }
                throw new IllegalArgumentException(INVALID_MISSING + this.toString());
            }
            if (captured == null) break;
            current.write(captured);
        }
        return Collections.unmodifiableList(list);
    }

    List<String> getDestBlocks() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder capture = null;
        boolean isAfterSource = false;
        boolean isInSourceBlocks = false;
        boolean isInDestBlock = false;
        for (int pos = 0; pos < this.content.size(); ++pos) {
            FilterParserChars current = (FilterParserChars)this.content.get(pos);
            if (!isAfterSource) {
                if (current.isBracketOpen()) {
                    isInSourceBlocks = true;
                    continue;
                }
                if (current.isBracketClose() && isInSourceBlocks) {
                    isInSourceBlocks = false;
                    continue;
                }
                if (current.isBracketClose() && !isInSourceBlocks) {
                    throw new IllegalArgumentException(INVALID_MISSING + this.toString());
                }
                if (isInSourceBlocks) continue;
                isAfterSource = true;
                continue;
            }
            if (!isInDestBlock) {
                if (current.isBracketOpen()) {
                    isInDestBlock = true;
                } else {
                    if (!current.isBracketClose()) continue;
                    throw new IllegalArgumentException(INVALID_MISSING + this.toString());
                }
            }
            if (current.isBracketOpen()) {
                capture = new StringBuilder();
                continue;
            }
            if (current.isBracketClose()) {
                if (capture != null) {
                    list.add(capture.toString());
                    capture = null;
                    continue;
                }
                throw new IllegalArgumentException(INVALID_MISSING + this.toString());
            }
            if (capture != null) {
                current.write(capture);
                continue;
            }
            throw new IllegalArgumentException("Invalid content after dest blocks in " + this.toString());
        }
        if (capture != null) {
            throw new IllegalArgumentException("Missing ] on the end in " + this.toString());
        }
        return Collections.unmodifiableList(list);
    }

    FilterParserFilter getFilter() {
        ArrayList<FilterParserChars> list = new ArrayList<FilterParserChars>();
        boolean isAfterSource = false;
        boolean isInSourceBlocks = false;
        for (int pos = 0; pos < this.content.size(); ++pos) {
            FilterParserChars current = (FilterParserChars)this.content.get(pos);
            if (!isAfterSource) {
                if (current.isBracketOpen()) {
                    isInSourceBlocks = true;
                    continue;
                }
                if (current.isBracketClose() && isInSourceBlocks) {
                    isInSourceBlocks = false;
                    continue;
                }
                if (current.isBracketClose() && !isInSourceBlocks) {
                    throw new IllegalArgumentException(INVALID_MISSING + this.toString());
                }
                if (isInSourceBlocks) continue;
                isAfterSource = true;
            }
            if (current.isBracketOpen() || current.isBracketClose()) break;
            list.add(current);
        }
        if (isInSourceBlocks) {
            throw new IllegalArgumentException("Missing ] in " + this.toString());
        }
        return new FilterParserFilter(list);
    }
}

