/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.ffprobecontainer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrameConst;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeBaseFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeCodecType;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePacket;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePictType;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrameConst;
import tv.hd3g.fflauncher.ffprobecontainer.SAXAttributeParserTraits;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserResult;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserSession;
import tv.hd3g.processlauncher.InputStreamConsumer;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class FFprobeResultSAX
extends DefaultHandler
implements ErrorHandler,
InputStreamConsumer,
SAXAttributeParserTraits {
    private static final String STREAM_INDEX = "stream_index";
    private static final Logger log = LogManager.getLogger();
    private static final SAXParserFactory factory;
    private String processSource;
    private final List<FFprobePacket> packets = new ArrayList<FFprobePacket>();
    private final List<FFprobeAudioFrame> audioFrames = new ArrayList<FFprobeAudioFrame>();
    private final List<FFprobeVideoFrame> videoFrames = new ArrayList<FFprobeVideoFrame>();
    private final List<FFprobeVideoFrameConst> olderVideoConsts = new ArrayList<FFprobeVideoFrameConst>();
    private final List<FFprobeAudioFrameConst> olderAudioConsts = new ArrayList<FFprobeAudioFrameConst>();
    private FFprobeVideoFrameConst videoConst;
    private FFprobeAudioFrameConst audioConst;

    public void onProcessStart(InputStream processInputStream, ProcesslauncherLifecycle source) {
        this.processSource = Optional.ofNullable(source).map(ProcesslauncherLifecycle::toString).orElse("");
        try {
            factory.newSAXParser().parse(new InputSource(processInputStream), (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("Can't load XML in SAX parser for {}", (Object)this.processSource, (Object)e);
            Optional.ofNullable(source).ifPresent(ProcesslauncherLifecycle::kill);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("packet")) {
            this.onPacket(attributes);
        } else if (qName.equals("frame")) {
            this.onFrame(attributes);
        }
    }

    private static Map<String, String> getAttributes(Attributes attributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(attributes.getLength());
        for (int pos = 0; pos < attributes.getLength(); ++pos) {
            result.put(attributes.getQName(pos), attributes.getValue(pos));
        }
        return result;
    }

    private void onPacket(Attributes attributes) {
        if (this.getAttrIntValue(attributes, STREAM_INDEX, -1) == -1) {
            return;
        }
        this.packets.add(new FFprobePacket(FFprobeCodecType.fromString(this.getAttrValue(attributes, "codec_type", FFprobeCodecType.OTHER.toString())), this.getAttrIntValue(attributes, STREAM_INDEX, -1), this.getAttrLongValue(attributes, "pts", -1L), this.getAttrFloatValue(attributes, "pts_time", -1.0f), this.getAttrLongValue(attributes, "dts", -1L), this.getAttrFloatValue(attributes, "dts_time", -1.0f), this.getAttrIntValue(attributes, "duration", -1), this.getAttrFloatValue(attributes, "duration_time", -1.0f), this.getAttrIntValue(attributes, "size", -1), this.getAttrLongValue(attributes, "pos", -1L), this.getAttrValue(attributes, "flags", null)));
    }

    private void onFrame(Attributes attributes) {
        if (this.getAttrIntValue(attributes, STREAM_INDEX, -1) == -1) {
            return;
        }
        FFprobeCodecType mediaType = FFprobeCodecType.fromString(this.getAttrValue(attributes, "media_type", FFprobeCodecType.OTHER.toString()));
        FFprobeBaseFrame baseFrame = new FFprobeBaseFrame(mediaType, this.getAttrIntValue(attributes, STREAM_INDEX, -1), this.getAttrBooleanValue(attributes, "key_frame", true), this.getAttrLongValue(attributes, "pts", -1L), this.getAttrFloatValue(attributes, "pts_time", -1.0f), this.getAttrLongValue(attributes, "pkt_dts", -1L), this.getAttrFloatValue(attributes, "pkt_dts_time", -1.0f), this.getAttrLongValue(attributes, "best_effort_timestamp", -1L), this.getAttrFloatValue(attributes, "best_effort_timestamp_time", -1.0f), this.getAttrIntValue(attributes, "pkt_duration", -1), this.getAttrFloatValue(attributes, "pkt_duration_time", -1.0f), this.getAttrLongValue(attributes, "pkt_pos", -1L), this.getAttrIntValue(attributes, "pkt_size", -1));
        if (mediaType == FFprobeCodecType.VIDEO) {
            this.onFrameVideo(attributes, baseFrame);
        } else if (mediaType == FFprobeCodecType.AUDIO) {
            this.onFrameAudio(attributes, baseFrame);
        } else {
            log.warn("Can't manage this frame type: {}, {}", (Object)mediaType, FFprobeResultSAX.getAttributes(attributes));
        }
    }

    private void onFrameVideo(Attributes attributes, FFprobeBaseFrame baseFrame) {
        FFprobeVideoFrame frame = new FFprobeVideoFrame(baseFrame, FFprobePictType.valueOf(this.getAttrValue(attributes, "pict_type", "UNKNOWN")), "1".equals(attributes.getValue("repeat_pict")));
        this.videoFrames.add(frame);
        FFprobeVideoFrameConst currentVideoConst = new FFprobeVideoFrameConst(frame, this.getAttrIntValue(attributes, "width", 0), this.getAttrIntValue(attributes, "height", 0), this.getAttrValue(attributes, "pix_fmt", null), this.getAttrValue(attributes, "sample_aspect_ratio", null), this.getAttrIntValue(attributes, "coded_picture_number", 0), this.getAttrIntValue(attributes, "display_picture_number", 0), this.getAttrBooleanValue(attributes, "interlaced_frame", false), this.getAttrBooleanValue(attributes, "top_field_first", false), this.getAttrValue(attributes, "color_range", null), this.getAttrValue(attributes, "color_space", null), this.getAttrValue(attributes, "color_primaries", null), this.getAttrValue(attributes, "color_transfer", null));
        if (this.videoConst == null) {
            this.videoConst = currentVideoConst;
        } else if (!this.videoConst.valuesEquals(currentVideoConst)) {
            this.olderVideoConsts.add(this.videoConst);
            this.videoConst = currentVideoConst;
        }
    }

    private void onFrameAudio(Attributes attributes, FFprobeBaseFrame baseFrame) {
        FFprobeAudioFrame frame = new FFprobeAudioFrame(baseFrame, this.getAttrIntValue(attributes, "nb_samples", -1));
        this.audioFrames.add(frame);
        FFprobeAudioFrameConst currentAudioConst = new FFprobeAudioFrameConst(frame, this.getAttrValue(attributes, "sample_fmt", null), this.getAttrIntValue(attributes, "channels", 0), ChannelLayout.parse(this.getAttrValue(attributes, "channel_layout", "")));
        if (this.audioConst == null) {
            this.audioConst = currentAudioConst;
        } else if (!this.audioConst.valuesEquals(currentAudioConst)) {
            this.olderAudioConsts.add(this.audioConst);
            this.audioConst = currentAudioConst;
        }
    }

    public ContainerAnalyserResult getResult(ContainerAnalyserSession session) {
        return new ContainerAnalyserResult(session, Collections.unmodifiableList(this.packets), Collections.unmodifiableList(this.audioFrames), Collections.unmodifiableList(this.videoFrames), this.videoConst, this.audioConst, Collections.unmodifiableList(this.olderVideoConsts), Collections.unmodifiableList(this.olderAudioConsts));
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        log.warn("SAX error (during {})", (Object)this.processSource, (Object)e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        log.warn("SAX error (during {})", (Object)this.processSource, (Object)e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        log.warn("SAX warning (during {})", (Object)this.processSource, (Object)e);
    }

    static {
        try {
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new InternalError("Can't load SAX parser", e);
        }
    }
}

