/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;

public class RawStdErrFilterEvent {
    private final String filterName;
    private final int filterChainPos;
    private final Map<String, String> content;

    RawStdErrFilterEvent(String rawLine) {
        List<String> items = MediaAnalyser.splitter(rawLine, ' ');
        String head = items.get(0);
        List<String> headItems = MediaAnalyser.splitter(head, '_');
        this.filterName = headItems.get(1);
        this.filterChainPos = Integer.valueOf(headItems.get(2));
        if (!items.get(1).equals("@")) {
            throw new IllegalArgumentException("Missing \"@\" on line \"" + rawLine + "\"");
        }
        if (!items.get(2).endsWith("]")) {
            throw new IllegalArgumentException("Missing \"]\" on line \"" + rawLine + "\"");
        }
        this.content = new LinkedHashMap<String, String>();
        int dataPos = rawLine.indexOf("]");
        List<String> dataItems = MediaAnalyser.splitter(rawLine.substring(dataPos + 1).trim(), ':');
        String key = null;
        String value = null;
        for (int pos = 0; pos < dataItems.size(); ++pos) {
            String entry = dataItems.get(pos);
            if (pos == 0) {
                key = entry;
                continue;
            }
            if (pos + 1 == dataItems.size()) {
                this.content.put(Objects.requireNonNull(key), entry.trim());
                continue;
            }
            int lastSpacePos = entry.lastIndexOf(" ");
            value = entry.substring(0, lastSpacePos);
            this.content.put(Objects.requireNonNull(key), value.trim());
            key = entry.substring(lastSpacePos + 1);
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public int getFilterChainPos() {
        return this.filterChainPos;
    }

    public Map<String, String> getContent() {
        return this.content;
    }

    public String toString() {
        return "RawStdErrFilterEvent(filterName=" + this.getFilterName() + ", filterChainPos=" + this.getFilterChainPos() + ", content=" + this.getContent() + ")";
    }
}

