/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;
import tv.hd3g.fflauncher.resultparser.Ebur128Summary;
import tv.hd3g.fflauncher.resultparser.RawStdErrFilterEvent;

public class RawStdErrEventParser {
    private static Logger log = LogManager.getLogger();
    private final Set<String> summaryZoneHeaders = Set.of("Integrated loudness", "I", "Threshold", "Loudness range", "LRA", "LRA low", "LRA high", "Sample peak", "Peak", "True peak");
    private final Consumer<RawStdErrFilterEvent> onRawStdErrEvent;
    private List<List<String>> rawSummaryZone;
    private boolean inEbur128SummaryZone;
    private Ebur128Summary ebur128Summary;

    public RawStdErrEventParser(Consumer<RawStdErrFilterEvent> onRawStdErrEvent) {
        this.onRawStdErrEvent = Objects.requireNonNull(onRawStdErrEvent, "\"onRawStdErrEvent\" can't to be null");
        this.inEbur128SummaryZone = false;
        this.rawSummaryZone = new ArrayList<List<String>>();
    }

    public void onLine(String rLine) {
        String line = rLine.trim();
        if (line.isEmpty()) {
            return;
        }
        log.trace("RawStdErrEvent line: {}", (Object)line);
        if (line.startsWith("[Parsed_") && line.contains(" @ ") && line.contains("]")) {
            if (this.inEbur128SummaryZone) {
                this.closeSummaryZone();
                this.inEbur128SummaryZone = false;
            }
            if (line.startsWith("[Parsed_ebur128_") && line.endsWith("] Summary:")) {
                this.inEbur128SummaryZone = true;
            } else {
                this.onRawStdErrEvent.accept(new RawStdErrFilterEvent(line));
            }
        } else if (this.inEbur128SummaryZone) {
            List<String> entry = MediaAnalyser.splitter(line, ':');
            if (this.summaryZoneHeaders.contains(entry.get(0))) {
                this.rawSummaryZone.add(entry);
            } else {
                this.closeSummaryZone();
                this.inEbur128SummaryZone = false;
            }
        }
    }

    private void closeSummaryZone() {
        if (this.inEbur128SummaryZone) {
            this.ebur128Summary = new Ebur128Summary();
            this.ebur128Summary.setRawLines(this.rawSummaryZone);
        }
        this.rawSummaryZone = new ArrayList<List<String>>();
    }

    public Ebur128Summary close() {
        if (this.inEbur128SummaryZone) {
            this.closeSummaryZone();
        }
        return this.ebur128Summary;
    }
}

