/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.ArrayList;
import java.util.List;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFrames;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFramesExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;
import tv.hd3g.fflauncher.resultparser.LavfiMetadataFilterFrame;

public class MetadataFilterFrameParser {
    private final List<LavfiRawMtdFrame> frames = new ArrayList<LavfiRawMtdFrame>();
    private final List<String> bucket = new ArrayList<String>();
    private LavfiMetadataFilterFrame currentFrame;

    public void onLine(String line) {
        if (line.startsWith("frame:")) {
            if (!this.bucket.isEmpty()) {
                this.currentFrame.setRawLines(this.bucket.stream());
                this.frames.add(this.currentFrame);
                this.bucket.clear();
            }
            this.currentFrame = this.parseFrameLine(line);
        } else {
            if (this.currentFrame == null) {
                throw new IllegalArgumentException("Missing frame declaration: " + line);
            }
            if (line.startsWith("lavfi.")) {
                this.bucket.add(line);
            } else {
                throw new IllegalArgumentException("Invalid line content inside frame: " + line);
            }
        }
    }

    public List<LavfiRawMtdFrame> close() {
        if (!this.bucket.isEmpty() && this.currentFrame != null) {
            this.currentFrame.setRawLines(this.bucket.stream());
            this.frames.add(this.currentFrame);
            this.bucket.clear();
        }
        return this.frames;
    }

    public <T, U extends LavfiMtdProgramFramesExtractor<T>> LavfiMtdProgramFrames<T> getMetadatasForFilter(U metadataExtractor) {
        if (!this.bucket.isEmpty() && this.currentFrame != null) {
            throw new IllegalStateException("You must close() before call this");
        }
        return metadataExtractor.getMetadatas(this.frames);
    }

    private LavfiMetadataFilterFrame parseFrameLine(String line) {
        List<String> items = MediaAnalyser.splitter(line, ' ');
        return new LavfiMetadataFilterFrame(MediaAnalyser.assertAndParse(items.get(0), "frame:", Integer::valueOf), MediaAnalyser.assertAndParse(items.get(1), "pts:", Long::valueOf), MediaAnalyser.assertAndParse(items.get(2), "pts_time:", Float::valueOf).floatValue());
    }
}

