/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;

public class LavfiMetadataFilterFrame
implements LavfiRawMtdFrame {
    private final int frame;
    private final long pts;
    private final float ptsTime;
    private Map<String, Map<String, String>> valuesByFilterKeysByFilterName;

    LavfiMetadataFilterFrame(int frame, long pts, float ptsTime) {
        this.frame = frame;
        this.pts = pts;
        this.ptsTime = ptsTime;
    }

    void setRawLines(Stream<String> sLines) {
        List<String> lines = sLines.map(line -> MediaAnalyser.assertAndParse(line, "lavfi.")).toList();
        this.valuesByFilterKeysByFilterName = lines.stream().collect(Collectors.groupingBy(line -> MediaAnalyser.splitter(MediaAnalyser.splitter(line, '.', 1).get(0), '=', 1).get(0), HashMap::new, Collectors.mapping(line -> MediaAnalyser.splitter(line, '='), Collectors.toMap(line -> {
            String kv = (String)line.get(0);
            int pos = kv.indexOf(".");
            if (pos == -1) {
                return "default";
            }
            return kv.substring(pos + 1);
        }, line -> (String)line.get(1)))));
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public long getPts() {
        return this.pts;
    }

    @Override
    public float getPtsTime() {
        return this.ptsTime;
    }

    @Override
    public Map<String, Map<String, String>> getValuesByFilterKeysByFilterName() {
        return this.valuesByFilterKeysByFilterName;
    }

    public String toString() {
        return "LavfiMetadataFilterFrame(frame=" + this.getFrame() + ", pts=" + this.getPts() + ", ptsTime=" + this.getPtsTime() + ", valuesByFilterKeysByFilterName=" + this.getValuesByFilterKeysByFilterName() + ")";
    }
}

