/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;

public class Ebur128Summary {
    private float integrated = Float.NEGATIVE_INFINITY;
    private float integratedThreshold = Float.NEGATIVE_INFINITY;
    private float loudnessRange = Float.NEGATIVE_INFINITY;
    private float loudnessRangeThreshold = Float.NEGATIVE_INFINITY;
    private float loudnessRangeLow = Float.NEGATIVE_INFINITY;
    private float loudnessRangeHigh = Float.NEGATIVE_INFINITY;
    private float samplePeak = Float.NEGATIVE_INFINITY;
    private float truePeak = Float.NEGATIVE_INFINITY;

    Ebur128Summary() {
    }

    void setRawLines(List<List<String>> rawSummaryZone) {
        rawSummaryZone.forEach(items -> {
            String keyName = ((String)items.get(0)).toUpperCase();
            Optional<Float> oValue = Ebur128Summary.extractValue(items);
            if (!oValue.isPresent()) {
                return;
            }
            Float value = oValue.get();
            switch (keyName) {
                case "I": {
                    this.integrated = value.floatValue();
                    this.integratedThreshold = Float.NEGATIVE_INFINITY;
                    this.loudnessRangeThreshold = Float.NEGATIVE_INFINITY;
                    this.samplePeak = Float.NEGATIVE_INFINITY;
                    this.truePeak = Float.NEGATIVE_INFINITY;
                    break;
                }
                case "LRA": {
                    this.loudnessRange = value.floatValue();
                    break;
                }
                case "LRA LOW": {
                    this.loudnessRangeLow = value.floatValue();
                    break;
                }
                case "LRA HIGH": {
                    this.loudnessRangeHigh = value.floatValue();
                    break;
                }
                case "THRESHOLD": {
                    if (this.integratedThreshold > Float.NEGATIVE_INFINITY) {
                        this.loudnessRangeThreshold = value.floatValue();
                        break;
                    }
                    this.integratedThreshold = value.floatValue();
                    break;
                }
                case "PEAK": {
                    if (this.samplePeak > Float.NEGATIVE_INFINITY) {
                        this.truePeak = value.floatValue();
                        break;
                    }
                    this.samplePeak = value.floatValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown " + (String)items.get(0) + ": " + (String)items.get(1));
                }
            }
        });
    }

    static Optional<Float> extractValue(List<String> items) {
        if (items.size() != 2) {
            return Optional.empty();
        }
        String rawValue = items.get(1);
        String numberValue = MediaAnalyser.splitter(rawValue, ' ', 1).get(0);
        if (numberValue.equalsIgnoreCase("-inf")) {
            return Optional.empty();
        }
        return Optional.ofNullable(Float.valueOf(numberValue));
    }

    public float getIntegrated() {
        return this.integrated;
    }

    public float getIntegratedThreshold() {
        return this.integratedThreshold;
    }

    public float getLoudnessRange() {
        return this.loudnessRange;
    }

    public float getLoudnessRangeThreshold() {
        return this.loudnessRangeThreshold;
    }

    public float getLoudnessRangeLow() {
        return this.loudnessRangeLow;
    }

    public float getLoudnessRangeHigh() {
        return this.loudnessRangeHigh;
    }

    public float getSamplePeak() {
        return this.samplePeak;
    }

    public float getTruePeak() {
        return this.truePeak;
    }

    public String toString() {
        return "Ebur128Summary(integrated=" + this.getIntegrated() + ", integratedThreshold=" + this.getIntegratedThreshold() + ", loudnessRange=" + this.getLoudnessRange() + ", loudnessRangeThreshold=" + this.getLoudnessRangeThreshold() + ", loudnessRangeLow=" + this.getLoudnessRangeLow() + ", loudnessRangeHigh=" + this.getLoudnessRangeHigh() + ", samplePeak=" + this.getSamplePeak() + ", truePeak=" + this.getTruePeak() + ")";
    }
}

