/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.resultparser;

import java.util.List;
import java.util.Map;
import tv.hd3g.fflauncher.recipes.MediaAnalyser;
import tv.hd3g.fflauncher.resultparser.Stereo;

public class Ebur128StrErrFilterEvent {
    private final float t;
    private final float target;
    private final float m;
    private final float s;
    private final float i;
    private final float lra;
    private final Stereo<Float> spk;
    private final Stereo<Float> ftpk;
    private final Stereo<Float> tpk;

    public Ebur128StrErrFilterEvent(Map<String, String> content) {
        this.t = this.extractValue(content.get("t"));
        this.target = this.extractValue(content.get("TARGET"));
        this.m = this.extractValue(content.get("M"));
        this.s = this.extractValue(content.get("S"));
        this.i = this.extractValue(content.get("I"));
        this.lra = this.extractValue(content.get("LRA"));
        this.spk = this.extractValues(content.get("SPK"));
        this.ftpk = this.extractValues(content.get("FTPK"));
        this.tpk = this.extractValues(content.get("TPK"));
    }

    private float extractValue(String rawValue) {
        if (rawValue == null || rawValue.equalsIgnoreCase("nan")) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.valueOf(MediaAnalyser.splitter(rawValue, ' ', 2).get(0)).floatValue();
    }

    private Stereo<Float> extractValues(String rawValue) {
        if (rawValue == null) {
            return new Stereo<Float>(Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY));
        }
        List<String> items = MediaAnalyser.splitter(rawValue, ' ');
        float l = items.get(0).equalsIgnoreCase("nan") ? Float.NEGATIVE_INFINITY : Float.valueOf(items.get(0)).floatValue();
        float r = items.get(1).equalsIgnoreCase("nan") ? Float.NEGATIVE_INFINITY : Float.valueOf(items.get(1)).floatValue();
        return new Stereo<Float>(Float.valueOf(l), Float.valueOf(r));
    }

    public float getT() {
        return this.t;
    }

    public float getTarget() {
        return this.target;
    }

    public float getM() {
        return this.m;
    }

    public float getS() {
        return this.s;
    }

    public float getI() {
        return this.i;
    }

    public float getLra() {
        return this.lra;
    }

    public Stereo<Float> getSpk() {
        return this.spk;
    }

    public Stereo<Float> getFtpk() {
        return this.ftpk;
    }

    public Stereo<Float> getTpk() {
        return this.tpk;
    }

    public String toString() {
        return "Ebur128StrErrFilterEvent(t=" + this.getT() + ", target=" + this.getTarget() + ", m=" + this.getM() + ", s=" + this.getS() + ", i=" + this.getI() + ", lra=" + this.getLra() + ", spk=" + this.getSpk() + ", ftpk=" + this.getFtpk() + ", tpk=" + this.getTpk() + ")";
    }
}

