/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.io.File;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.ConversionTool;
import tv.hd3g.fflauncher.FFprobe;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeResultSAX;
import tv.hd3g.fflauncher.recipes.ContainerAnalyser;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserResult;
import tv.hd3g.processlauncher.ExecutableToolRunning;

public class ContainerAnalyserSession {
    private static Logger log = LogManager.getLogger();
    private final ContainerAnalyser containerAnalyser;
    private final String source;
    private final File sourceFile;

    ContainerAnalyserSession(ContainerAnalyser containerAnalyser, String source, File sourceFile) {
        this.containerAnalyser = containerAnalyser;
        if (source == null && sourceFile == null) {
            throw new IllegalArgumentException("No source for ffmpeg");
        }
        this.source = source;
        this.sourceFile = sourceFile;
    }

    public ContainerAnalyserResult process() {
        FFprobe ffprobe = this.containerAnalyser.createFFprobe();
        ffprobe.setHidebanner();
        ffprobe.setShowFrames();
        ffprobe.setShowPackets();
        ffprobe.setPrintFormat(FFprobe.FFPrintFormat.XML);
        if (this.source != null) {
            ffprobe.addSimpleInputSource(this.source, new String[0]);
        } else {
            ffprobe.addSimpleInputSource(this.sourceFile, new String[0]);
        }
        ffprobe.fixIOParametredVars(ConversionTool.APPEND_PARAM_AT_END, ConversionTool.APPEND_PARAM_AT_END);
        FFprobeResultSAX parser = new FFprobeResultSAX();
        ExecutableToolRunning runTool = ffprobe.executeDirectStdout(this.containerAnalyser.getExecutableFinder(), parser);
        log.debug("Start {}", (Object)runTool.getLifecyle().getLauncher().getFullCommandLine());
        runTool.waitForEndAndCheckExecution();
        return parser.getResult(this);
    }

    public ContainerAnalyserResult offlineProcess(InputStream ffprobeStdOut) {
        FFprobeResultSAX parser = new FFprobeResultSAX();
        parser.onProcessStart(ffprobeStdOut, null);
        parser.onClose(null);
        return parser.getResult(this);
    }

    public ContainerAnalyser getContainerAnalyser() {
        return this.containerAnalyser;
    }

    public String getSource() {
        return this.source;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

