/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.recipes;

import java.util.Set;
import java.util.function.Consumer;
import tv.hd3g.fflauncher.filtering.AbstractFilterMetadata;
import tv.hd3g.fflauncher.filtering.AudioFilterAMetadata;
import tv.hd3g.fflauncher.filtering.AudioFilterAPhasemeter;
import tv.hd3g.fflauncher.filtering.AudioFilterAstats;
import tv.hd3g.fflauncher.filtering.AudioFilterEbur128;
import tv.hd3g.fflauncher.filtering.AudioFilterSilencedetect;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.AudioFilterVolumedetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlackdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlockdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterBlurdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterCropdetect;
import tv.hd3g.fflauncher.filtering.VideoFilterFreezedetect;
import tv.hd3g.fflauncher.filtering.VideoFilterIdet;
import tv.hd3g.fflauncher.filtering.VideoFilterMEstimate;
import tv.hd3g.fflauncher.filtering.VideoFilterMetadata;
import tv.hd3g.fflauncher.filtering.VideoFilterSiti;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;

public interface AddFiltersTraits {
    public boolean addFilter(VideoFilterSupplier var1);

    public boolean addFilter(AudioFilterSupplier var1);

    default public AddFiltersTraits addFilterPhasemeter(Consumer<AudioFilterAPhasemeter> filterifPresent) {
        return this.addOptionalFilter(new AudioFilterAPhasemeter(), filterifPresent);
    }

    default public AddFiltersTraits addFilterAstats(Consumer<AudioFilterAstats> filterifPresent) {
        AudioFilterAstats f = new AudioFilterAstats();
        f.setSelectedMetadatas();
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public AddFiltersTraits addFilterSilencedetect(Consumer<AudioFilterSilencedetect> filterifPresent) {
        AudioFilterSilencedetect f = new AudioFilterSilencedetect();
        f.setMono(true);
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public AddFiltersTraits addFilterVolumedetect(Consumer<AudioFilterVolumedetect> filterifPresent) {
        return this.addOptionalFilter(new AudioFilterVolumedetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterEbur128(Consumer<AudioFilterEbur128> filterifPresent) {
        AudioFilterEbur128 f = new AudioFilterEbur128();
        f.setPeakMode(Set.of(AudioFilterEbur128.Peak.SAMPLE, AudioFilterEbur128.Peak.TRUE));
        return this.addOptionalFilter(f, filterifPresent);
    }

    default public AddFiltersTraits addFilterSiti(Consumer<VideoFilterSiti> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterSiti(), filterifPresent);
    }

    default public AddFiltersTraits addFilterIdet(Consumer<VideoFilterIdet> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterIdet(), filterifPresent);
    }

    default public AddFiltersTraits addFilterFreezedetect(Consumer<VideoFilterFreezedetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterFreezedetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterBlackdetect(Consumer<VideoFilterBlackdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlackdetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterCropdetect(Consumer<VideoFilterCropdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterCropdetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterBlockdetect(Consumer<VideoFilterBlockdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlockdetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterBlurdetect(Consumer<VideoFilterBlurdetect> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterBlurdetect(), filterifPresent);
    }

    default public AddFiltersTraits addFilterMEstimate(Consumer<VideoFilterMEstimate> filterifPresent) {
        return this.addOptionalFilter(new VideoFilterMEstimate(), filterifPresent);
    }

    default public AddFiltersTraits addFilterMetadata(Consumer<VideoFilterMetadata> filterifPresent) {
        VideoFilterMetadata vMetadata = new VideoFilterMetadata(AbstractFilterMetadata.Mode.PRINT);
        vMetadata.setFile("-");
        return this.addOptionalFilter(vMetadata, filterifPresent);
    }

    default public AddFiltersTraits addFilterAMetadata(Consumer<AudioFilterAMetadata> filterifPresent) {
        AudioFilterAMetadata aMetadata = new AudioFilterAMetadata(AbstractFilterMetadata.Mode.PRINT);
        aMetadata.setFile("-");
        return this.addOptionalFilter(aMetadata, filterifPresent);
    }

    default public <T extends AudioFilterSupplier> AddFiltersTraits addOptionalFilter(T filter, Consumer<T> filterifPresent) {
        if (this.addFilter(filter)) {
            filterifPresent.accept(filter);
        }
        return this;
    }

    default public <T extends VideoFilterSupplier> AddFiltersTraits addOptionalFilter(T filter, Consumer<T> filterifPresent) {
        if (this.addFilter(filter)) {
            filterifPresent.accept(filter);
        }
        return this;
    }
}

