/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.lavfimtd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdPosition;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class LavfiMtdProgramFrames<T> {
    private final Map<LavfiMtdPosition, T> frames;

    public LavfiMtdProgramFrames(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames, String lavfiMtdKeyName, Function<Map<String, String>, Optional<T>> transformer) {
        TreeMap tempFrames = new TreeMap();
        extractedRawMtdFrames.forEach(raw -> {
            Map<String, String> rawValues = raw.getValuesByFilterKeysByFilterName().get(lavfiMtdKeyName);
            if (rawValues == null) {
                return;
            }
            Optional oValue = (Optional)transformer.apply(rawValues);
            oValue.ifPresent(v -> tempFrames.put(raw.getLavfiMtdPosition(), v));
        });
        this.frames = Collections.unmodifiableMap(tempFrames);
    }

    public Map<LavfiMtdPosition, T> getFrames() {
        return this.frames;
    }
}

