/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering.lavfimtd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdEvent;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class LavfiMtdProgramEvents {
    private static final String SUFFIX_END = "_end";
    private static final String SUFFIX_START = "_start";
    private static Logger log = LogManager.getLogger();
    private final List<LavfiMtdEvent> events;

    private LavfiMtdProgramEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames, String lavfiMtdFilterKeyName, String lavfiMtdKeyName, String eventsNameToSet) {
        this.events = Collections.unmodifiableList(extractedRawMtdFrames.stream().filter(frame -> {
            Map<String, Map<String, String>> entries = frame.getValuesByFilterKeysByFilterName();
            Set<String> itemKeys = entries.keySet();
            if (itemKeys.contains(lavfiMtdFilterKeyName)) {
                Set<String> subItemKeys = entries.get(lavfiMtdFilterKeyName).keySet();
                return subItemKeys.contains(lavfiMtdKeyName + SUFFIX_START) || subItemKeys.contains(lavfiMtdKeyName + SUFFIX_END);
            }
            return itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_START) || itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_END);
        }).flatMap(frame -> {
            Map<String, Map<String, String>> entries = frame.getValuesByFilterKeysByFilterName();
            Set<String> itemKeys = entries.keySet();
            if (itemKeys.contains(lavfiMtdFilterKeyName)) {
                return Stream.of(this.mapStyle0(lavfiMtdFilterKeyName, lavfiMtdKeyName, (LavfiRawMtdFrame)frame, entries));
            }
            if (itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_START)) {
                return this.mapStyle1(lavfiMtdFilterKeyName + SUFFIX_START, lavfiMtdKeyName, (LavfiRawMtdFrame)frame, entries, FrameType.START);
            }
            if (itemKeys.contains(lavfiMtdFilterKeyName + SUFFIX_END)) {
                return this.mapStyle1(lavfiMtdFilterKeyName + SUFFIX_END, lavfiMtdKeyName, (LavfiRawMtdFrame)frame, entries, FrameType.END);
            }
            throw new IllegalStateException("Can't extract to event: " + frame);
        }).reduce(new ArrayList(0), (list, frameDef) -> {
            if (frameDef.type == FrameType.START) {
                list.add(new LavfiMtdEvent(eventsNameToSet, frameDef.scope, Float.valueOf(frameDef.time).floatValue(), Float.NaN));
            } else {
                int lastPos = LavfiMtdProgramEvents.reverseSearch(list, eventsNameToSet, frameDef.scope);
                if (lastPos == -1) {
                    log.warn("Can't found start event for {}", frameDef);
                    return list;
                }
                LavfiMtdEvent previousStart = (LavfiMtdEvent)list.get(lastPos);
                list.set(lastPos, new LavfiMtdEvent(eventsNameToSet, frameDef.scope, previousStart.start(), Float.valueOf(frameDef.time).floatValue()));
            }
            return list;
        }, (l, r) -> {
            l.addAll(r);
            return l;
        }));
    }

    private FrameDef mapStyle0(String lavfiMtdFilterKeyName, String lavfiMtdKeyName, LavfiRawMtdFrame frame, Map<String, Map<String, String>> entries) {
        Map<String, String> subEntry = entries.get(lavfiMtdFilterKeyName);
        if (subEntry.containsKey(lavfiMtdKeyName + SUFFIX_START)) {
            return new FrameDef(frame, FrameType.START, null, subEntry.get(lavfiMtdKeyName + SUFFIX_START));
        }
        if (subEntry.containsKey(lavfiMtdKeyName + SUFFIX_END)) {
            return new FrameDef(frame, FrameType.END, null, subEntry.get(lavfiMtdKeyName + SUFFIX_END));
        }
        throw new IllegalStateException("Can't extract to event (mapStyle0): " + frame);
    }

    private Stream<FrameDef> mapStyle1(String keyName, String lavfiMtdKeyName, LavfiRawMtdFrame frame, Map<String, Map<String, String>> entries, FrameType type) {
        Map<String, String> subEntry = entries.get(keyName);
        if (subEntry.containsKey(lavfiMtdKeyName)) {
            return Stream.of(new FrameDef(frame, type, null, subEntry.get(lavfiMtdKeyName)));
        }
        return subEntry.entrySet().stream().map(entry -> new FrameDef(frame, type, (String)entry.getKey(), (String)entry.getValue()));
    }

    private static final int reverseSearch(List<LavfiMtdEvent> list, String searchName, String searchScope) {
        for (int pos = list.size() - 1; pos >= 0; --pos) {
            LavfiMtdEvent entry = list.get(pos);
            if (!entry.name().equals(searchName) || entry.scope() != null && !entry.scope().equals(searchScope)) continue;
            return pos;
        }
        return -1;
    }

    public LavfiMtdProgramEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames, String lavfiMtdKeyName) {
        this(extractedRawMtdFrames, lavfiMtdKeyName, "default", lavfiMtdKeyName);
    }

    public LavfiMtdProgramEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames, String lavfiMtdFilterKeyName, String lavfiMtdKeyName) {
        this(extractedRawMtdFrames, lavfiMtdFilterKeyName, lavfiMtdKeyName, lavfiMtdKeyName);
    }

    public List<LavfiMtdEvent> getEvents() {
        return this.events;
    }

    private record FrameDef(LavfiRawMtdFrame frame, FrameType type, String scope, String time) {
    }

    private static enum FrameType {
        START,
        END;

    }
}

