/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFrames;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFramesExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class VideoFilterSiti
implements VideoFilterSupplier,
LavfiMtdProgramFramesExtractor<LavfiMtdSiti> {
    private boolean printSummary;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("siti");
        f.addOptionalArgument("print_summary", this.printSummary, "1");
        return f;
    }

    @Override
    public LavfiMtdProgramFrames<LavfiMtdSiti> getMetadatas(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramFrames<LavfiMtdSiti>(extractedRawMtdFrames, "siti", rawFrames -> {
            String si = (String)rawFrames.get("si");
            String ti = (String)rawFrames.get("ti");
            if (si == null || ti == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(new LavfiMtdSiti(Float.valueOf(si).floatValue(), Float.valueOf(ti).floatValue()));
        });
    }

    public static LavfiMtdSitiSummary computeSitiStats(LavfiMtdProgramFrames<LavfiMtdSiti> frames) {
        DoubleSummaryStatistics si = frames.getFrames().values().stream().mapToDouble(f -> f.si).summaryStatistics();
        DoubleSummaryStatistics ti = frames.getFrames().values().stream().mapToDouble(f -> f.ti).summaryStatistics();
        return new LavfiMtdSitiSummary(si, ti);
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterSiti)) {
            return false;
        }
        VideoFilterSiti other = (VideoFilterSiti)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isPrintSummary() == other.isPrintSummary();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterSiti;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrintSummary() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "VideoFilterSiti(printSummary=" + this.isPrintSummary() + ")";
    }

    public record LavfiMtdSitiSummary(DoubleSummaryStatistics si, DoubleSummaryStatistics ti) {
    }

    public record LavfiMtdSiti(float si, float ti) {
    }
}

