/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFrames;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFramesExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class VideoFilterIdet
implements VideoFilterSupplier,
LavfiMtdProgramFramesExtractor<LavfiMtdIdet> {
    private float intlThres = -1.0f;
    private float progThres = -1.0f;
    private float repThres = -1.0f;
    private int halfLife = -1;
    private boolean analyzeInterlacedFlag;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("idet");
        f.addOptionalArgument("analyze_interlaced_flag", this.analyzeInterlacedFlag, "1");
        f.addOptionalNonNegativeArgument("intl_thres", this.intlThres);
        f.addOptionalNonNegativeArgument("prog_thres", this.progThres);
        f.addOptionalNonNegativeArgument("half_life", this.halfLife);
        return f;
    }

    @Override
    public LavfiMtdProgramFrames<LavfiMtdIdet> getMetadatas(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramFrames<LavfiMtdIdet>(extractedRawMtdFrames, "idet", rawFrames -> {
            try {
                LavfiMtdIdetFrame single = new LavfiMtdIdetFrame(LavfiMtdIdetSingleFrameType.valueOf(((String)rawFrames.get("single.current_frame")).toUpperCase()), this.parseInt((String)rawFrames.get("single.tff")), this.parseInt((String)rawFrames.get("single.bff")), this.parseInt((String)rawFrames.get("single.progressive")), this.parseInt((String)rawFrames.get("single.undetermined")));
                LavfiMtdIdetFrame multiple = new LavfiMtdIdetFrame(LavfiMtdIdetSingleFrameType.valueOf(((String)rawFrames.get("multiple.current_frame")).toUpperCase()), this.parseInt((String)rawFrames.get("multiple.tff")), this.parseInt((String)rawFrames.get("multiple.bff")), this.parseInt((String)rawFrames.get("multiple.progressive")), this.parseInt((String)rawFrames.get("multiple.undetermined")));
                LavfiMtdIdetRepeatedFrame repeated = new LavfiMtdIdetRepeatedFrame(LavfiMtdIdetRepeatedFrameType.valueOf(((String)rawFrames.get("repeated.current_frame")).toUpperCase()), this.parseInt((String)rawFrames.get("repeated.neither")), this.parseInt((String)rawFrames.get("repeated.top")), this.parseInt((String)rawFrames.get("repeated.bottom")));
                return Optional.ofNullable(new LavfiMtdIdet(single, multiple, repeated));
            }
            catch (NullPointerException e) {
                return Optional.empty();
            }
        });
    }

    public float getIntlThres() {
        return this.intlThres;
    }

    public float getProgThres() {
        return this.progThres;
    }

    public float getRepThres() {
        return this.repThres;
    }

    public int getHalfLife() {
        return this.halfLife;
    }

    public boolean isAnalyzeInterlacedFlag() {
        return this.analyzeInterlacedFlag;
    }

    public void setIntlThres(float intlThres) {
        this.intlThres = intlThres;
    }

    public void setProgThres(float progThres) {
        this.progThres = progThres;
    }

    public void setRepThres(float repThres) {
        this.repThres = repThres;
    }

    public void setHalfLife(int halfLife) {
        this.halfLife = halfLife;
    }

    public void setAnalyzeInterlacedFlag(boolean analyzeInterlacedFlag) {
        this.analyzeInterlacedFlag = analyzeInterlacedFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterIdet)) {
            return false;
        }
        VideoFilterIdet other = (VideoFilterIdet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getIntlThres(), other.getIntlThres()) != 0) {
            return false;
        }
        if (Float.compare(this.getProgThres(), other.getProgThres()) != 0) {
            return false;
        }
        if (Float.compare(this.getRepThres(), other.getRepThres()) != 0) {
            return false;
        }
        if (this.getHalfLife() != other.getHalfLife()) {
            return false;
        }
        return this.isAnalyzeInterlacedFlag() == other.isAnalyzeInterlacedFlag();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterIdet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getIntlThres());
        result = result * 59 + Float.floatToIntBits(this.getProgThres());
        result = result * 59 + Float.floatToIntBits(this.getRepThres());
        result = result * 59 + this.getHalfLife();
        result = result * 59 + (this.isAnalyzeInterlacedFlag() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "VideoFilterIdet(intlThres=" + this.getIntlThres() + ", progThres=" + this.getProgThres() + ", repThres=" + this.getRepThres() + ", halfLife=" + this.getHalfLife() + ", analyzeInterlacedFlag=" + this.isAnalyzeInterlacedFlag() + ")";
    }

    public record LavfiMtdIdetFrame(LavfiMtdIdetSingleFrameType currentFrame, int tff, int bff, int progressive, int undetermined) {
    }

    public static enum LavfiMtdIdetSingleFrameType {
        TFF,
        BFF,
        PROGRESSIVE,
        UNDETERMINED;

    }

    public record LavfiMtdIdetRepeatedFrame(LavfiMtdIdetRepeatedFrameType currentFrame, int neither, int top, int bottom) {
    }

    public static enum LavfiMtdIdetRepeatedFrameType {
        TOP,
        BOTTOM,
        NEITHER;

    }

    public record LavfiMtdIdet(LavfiMtdIdetFrame single, LavfiMtdIdetFrame multiple, LavfiMtdIdetRepeatedFrame repeated) {
    }
}

