/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.time.Duration;
import java.util.List;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEvents;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEventsExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class VideoFilterFreezedetect
implements VideoFilterSupplier,
LavfiMtdProgramEventsExtractor {
    private float noiseToleranceRatio = -1.0f;
    private int noiseToleranceDb = Integer.MIN_VALUE;
    private Duration freezeDuration;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("freezedetect");
        f.addOptionalDurationSecArgument("duration", this.freezeDuration);
        f.addOptionalArgument("noise", this.noiseToleranceDb > Integer.MIN_VALUE, "-" + Math.abs(this.noiseToleranceDb) + "dB");
        f.addOptionalNonNegativeArgument("noise", this.noiseToleranceRatio);
        return f;
    }

    @Override
    public LavfiMtdProgramEvents getEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramEvents(extractedRawMtdFrames, "freezedetect", "freeze");
    }

    public float getNoiseToleranceRatio() {
        return this.noiseToleranceRatio;
    }

    public int getNoiseToleranceDb() {
        return this.noiseToleranceDb;
    }

    public Duration getFreezeDuration() {
        return this.freezeDuration;
    }

    public void setNoiseToleranceRatio(float noiseToleranceRatio) {
        this.noiseToleranceRatio = noiseToleranceRatio;
    }

    public void setNoiseToleranceDb(int noiseToleranceDb) {
        this.noiseToleranceDb = noiseToleranceDb;
    }

    public void setFreezeDuration(Duration freezeDuration) {
        this.freezeDuration = freezeDuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterFreezedetect)) {
            return false;
        }
        VideoFilterFreezedetect other = (VideoFilterFreezedetect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getNoiseToleranceRatio(), other.getNoiseToleranceRatio()) != 0) {
            return false;
        }
        if (this.getNoiseToleranceDb() != other.getNoiseToleranceDb()) {
            return false;
        }
        Duration this$freezeDuration = this.getFreezeDuration();
        Duration other$freezeDuration = other.getFreezeDuration();
        return !(this$freezeDuration == null ? other$freezeDuration != null : !((Object)this$freezeDuration).equals(other$freezeDuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterFreezedetect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getNoiseToleranceRatio());
        result = result * 59 + this.getNoiseToleranceDb();
        Duration $freezeDuration = this.getFreezeDuration();
        result = result * 59 + ($freezeDuration == null ? 43 : ((Object)$freezeDuration).hashCode());
        return result;
    }

    public String toString() {
        return "VideoFilterFreezedetect(noiseToleranceRatio=" + this.getNoiseToleranceRatio() + ", noiseToleranceDb=" + this.getNoiseToleranceDb() + ", freezeDuration=" + this.getFreezeDuration() + ")";
    }
}

