/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.VideoFilterSupplier;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFrames;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFramesExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class VideoFilterCropdetect
implements VideoFilterSupplier,
LavfiMtdProgramFramesExtractor<LavfiMtdCropdetect> {
    private boolean modeMvedges;
    private int limit = -1;
    private int round = -1;
    private int skip = -1;
    private int reset = -1;
    private int mvThreshold = -1;
    private int low = -1;
    private int high = -1;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("cropdetect");
        f.addOptionalArgument("mode", this.modeMvedges, "mvedges");
        f.addOptionalNonNegativeArgument("limit", this.limit);
        f.addOptionalNonNegativeArgument("round", this.round);
        f.addOptionalNonNegativeArgument("skip", this.skip);
        f.addOptionalNonNegativeArgument("reset", this.reset);
        f.addOptionalNonNegativeArgument("mv_threshold", this.mvThreshold);
        f.addOptionalNonNegativeArgument("low", this.low);
        f.addOptionalNonNegativeArgument("high", this.high);
        return f;
    }

    @Override
    public LavfiMtdProgramFrames<LavfiMtdCropdetect> getMetadatas(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramFrames<LavfiMtdCropdetect>(extractedRawMtdFrames, "cropdetect", rawFrames -> {
            try {
                int x1 = Integer.parseInt((String)rawFrames.get("x1"));
                int x2 = Integer.parseInt((String)rawFrames.get("x2"));
                int y1 = Integer.parseInt((String)rawFrames.get("y1"));
                int y2 = Integer.parseInt((String)rawFrames.get("y2"));
                int w = Integer.parseInt((String)rawFrames.get("w"));
                int h = Integer.parseInt((String)rawFrames.get("h"));
                int x = Integer.parseInt((String)rawFrames.get("x"));
                int y = Integer.parseInt((String)rawFrames.get("y"));
                return Optional.ofNullable(new LavfiMtdCropdetect(x1, x2, y1, y2, w, h, x, y));
            }
            catch (NullPointerException e) {
                return Optional.empty();
            }
        });
    }

    public boolean isModeMvedges() {
        return this.modeMvedges;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getRound() {
        return this.round;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getReset() {
        return this.reset;
    }

    public int getMvThreshold() {
        return this.mvThreshold;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public void setModeMvedges(boolean modeMvedges) {
        this.modeMvedges = modeMvedges;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public void setReset(int reset) {
        this.reset = reset;
    }

    public void setMvThreshold(int mvThreshold) {
        this.mvThreshold = mvThreshold;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFilterCropdetect)) {
            return false;
        }
        VideoFilterCropdetect other = (VideoFilterCropdetect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isModeMvedges() != other.isModeMvedges()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getRound() != other.getRound()) {
            return false;
        }
        if (this.getSkip() != other.getSkip()) {
            return false;
        }
        if (this.getReset() != other.getReset()) {
            return false;
        }
        if (this.getMvThreshold() != other.getMvThreshold()) {
            return false;
        }
        if (this.getLow() != other.getLow()) {
            return false;
        }
        return this.getHigh() == other.getHigh();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoFilterCropdetect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isModeMvedges() ? 79 : 97);
        result = result * 59 + this.getLimit();
        result = result * 59 + this.getRound();
        result = result * 59 + this.getSkip();
        result = result * 59 + this.getReset();
        result = result * 59 + this.getMvThreshold();
        result = result * 59 + this.getLow();
        result = result * 59 + this.getHigh();
        return result;
    }

    public String toString() {
        return "VideoFilterCropdetect(modeMvedges=" + this.isModeMvedges() + ", limit=" + this.getLimit() + ", round=" + this.getRound() + ", skip=" + this.getSkip() + ", reset=" + this.getReset() + ", mvThreshold=" + this.getMvThreshold() + ", low=" + this.getLow() + ", high=" + this.getHigh() + ")";
    }

    public record LavfiMtdCropdetect(int x1, int x2, int y1, int y2, int w, int h, int x, int y) {
    }
}

