/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.time.Duration;
import java.util.List;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEvents;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEventsExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class AudioFilterSilencedetect
implements AudioFilterSupplier,
LavfiMtdProgramEventsExtractor {
    private boolean mono;
    private Duration duration;
    private int noiseDb = -1;
    private float noiseRatio = -1.0f;

    @Override
    public Filter toFilter() {
        Filter f = new Filter("silencedetect");
        f.addOptionalArgument("mono", this.mono, "1");
        f.addOptionalDurationSecArgument("duration", this.duration);
        f.addOptionalNonNegativeArgument("noise", this.noiseDb);
        f.addOptionalNonNegativeArgument("noise", this.noiseRatio);
        return f;
    }

    @Override
    public LavfiMtdProgramEvents getEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramEvents(extractedRawMtdFrames, "silence");
    }

    public boolean isMono() {
        return this.mono;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public int getNoiseDb() {
        return this.noiseDb;
    }

    public float getNoiseRatio() {
        return this.noiseRatio;
    }

    public void setMono(boolean mono) {
        this.mono = mono;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public void setNoiseDb(int noiseDb) {
        this.noiseDb = noiseDb;
    }

    public void setNoiseRatio(float noiseRatio) {
        this.noiseRatio = noiseRatio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioFilterSilencedetect)) {
            return false;
        }
        AudioFilterSilencedetect other = (AudioFilterSilencedetect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMono() != other.isMono()) {
            return false;
        }
        if (this.getNoiseDb() != other.getNoiseDb()) {
            return false;
        }
        if (Float.compare(this.getNoiseRatio(), other.getNoiseRatio()) != 0) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioFilterSilencedetect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMono() ? 79 : 97);
        result = result * 59 + this.getNoiseDb();
        result = result * 59 + Float.floatToIntBits(this.getNoiseRatio());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        return result;
    }

    public String toString() {
        return "AudioFilterSilencedetect(mono=" + this.isMono() + ", duration=" + this.getDuration() + ", noiseDb=" + this.getNoiseDb() + ", noiseRatio=" + this.getNoiseRatio() + ")";
    }
}

