/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.filtering;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import tv.hd3g.fflauncher.filtering.AudioFilterSupplier;
import tv.hd3g.fflauncher.filtering.Filter;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEvents;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramEventsExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFrames;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiMtdProgramFramesExtractor;
import tv.hd3g.fflauncher.filtering.lavfimtd.LavfiRawMtdFrame;

public class AudioFilterAPhasemeter
implements AudioFilterSupplier,
LavfiMtdProgramFramesExtractor<LavfiMtdAPhaseMeter>,
LavfiMtdProgramEventsExtractor {
    private static final String APHASEMETER = "aphasemeter";
    private boolean phasing;
    private boolean video;
    private float tolerance = -1.0f;
    private int angle = -1;
    private Duration duration;

    @Override
    public Filter toFilter() {
        Filter f = new Filter(APHASEMETER);
        f.addOptionalArgument("phasing", this.phasing, "1");
        f.addOptionalDurationSecArgument("duration", this.duration);
        f.addOptionalNonNegativeArgument("tolerance", this.tolerance);
        f.addOptionalNonNegativeArgument("angle", this.angle);
        if (!this.video) {
            f.addArgument("video", "0");
        }
        return f;
    }

    @Override
    public LavfiMtdProgramFrames<LavfiMtdAPhaseMeter> getMetadatas(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramFrames<LavfiMtdAPhaseMeter>(extractedRawMtdFrames, APHASEMETER, rawFrames -> Optional.ofNullable((String)rawFrames.get("phase")).map(Float::parseFloat).map(LavfiMtdAPhaseMeter::new));
    }

    @Override
    public LavfiMtdProgramEvents getEvents(List<? extends LavfiRawMtdFrame> extractedRawMtdFrames) {
        return new LavfiMtdProgramEvents(extractedRawMtdFrames, APHASEMETER, "mono");
    }

    public boolean isPhasing() {
        return this.phasing;
    }

    public boolean isVideo() {
        return this.video;
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public int getAngle() {
        return this.angle;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setPhasing(boolean phasing) {
        this.phasing = phasing;
    }

    public void setVideo(boolean video) {
        this.video = video;
    }

    public void setTolerance(float tolerance) {
        this.tolerance = tolerance;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioFilterAPhasemeter)) {
            return false;
        }
        AudioFilterAPhasemeter other = (AudioFilterAPhasemeter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPhasing() != other.isPhasing()) {
            return false;
        }
        if (this.isVideo() != other.isVideo()) {
            return false;
        }
        if (Float.compare(this.getTolerance(), other.getTolerance()) != 0) {
            return false;
        }
        if (this.getAngle() != other.getAngle()) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioFilterAPhasemeter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPhasing() ? 79 : 97);
        result = result * 59 + (this.isVideo() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getTolerance());
        result = result * 59 + this.getAngle();
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        return result;
    }

    public String toString() {
        return "AudioFilterAPhasemeter(phasing=" + this.isPhasing() + ", video=" + this.isVideo() + ", tolerance=" + this.getTolerance() + ", angle=" + this.getAngle() + ", duration=" + this.getDuration() + ")";
    }

    public record LavfiMtdAPhaseMeter(float phase) {
    }
}

