/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.ffprobecontainer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import tv.hd3g.fflauncher.enums.ChannelLayout;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeAudioFrameConst;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeBaseFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeCodecType;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePacket;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobePictType;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrame;
import tv.hd3g.fflauncher.ffprobecontainer.FFprobeVideoFrameConst;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserResult;
import tv.hd3g.fflauncher.recipes.ContainerAnalyserSession;
import tv.hd3g.processlauncher.InputStreamConsumer;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class FFprobeResultSAX
extends DefaultHandler
implements ErrorHandler,
InputStreamConsumer {
    private static final String CAN_T_EXTRACT_NUMBER_FROM = "Can't extract number from {}=\"{}\"";
    private static final Logger log = LogManager.getLogger();
    private static final SAXParserFactory factory;
    private String processSource;
    private final List<FFprobePacket> packets = new ArrayList<FFprobePacket>();
    private final List<FFprobeAudioFrame> audioFrames = new ArrayList<FFprobeAudioFrame>();
    private final List<FFprobeVideoFrame> videoFrames = new ArrayList<FFprobeVideoFrame>();
    private final List<FFprobeVideoFrameConst> olderVideoConsts = new ArrayList<FFprobeVideoFrameConst>();
    private final List<FFprobeAudioFrameConst> olderAudioConsts = new ArrayList<FFprobeAudioFrameConst>();
    private FFprobeVideoFrameConst videoConst;
    private FFprobeAudioFrameConst audioConst;

    public void onProcessStart(InputStream processInputStream, ProcesslauncherLifecycle source) {
        this.processSource = Optional.ofNullable(source).map(ProcesslauncherLifecycle::toString).orElse("");
        try {
            factory.newSAXParser().parse(new InputSource(processInputStream), (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("Can't load XML in SAX parser for {}", (Object)this.processSource, (Object)e);
            Optional.ofNullable(source).ifPresent(ProcesslauncherLifecycle::kill);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("packet")) {
            this.onPacket(attributes);
        } else if (qName.equals("frame")) {
            this.onFrame(attributes);
        }
    }

    private static Map<String, String> getAttributes(Attributes attributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(attributes.getLength());
        for (int pos = 0; pos < attributes.getLength(); ++pos) {
            result.put(attributes.getQName(pos), attributes.getValue(pos));
        }
        return result;
    }

    private void onPacket(Attributes attributes) {
        if (attributes.getLength() != 11) {
            log.error("Invalid <packet>, expect 11 attributes, get {}: {}", (Object)attributes.getLength(), FFprobeResultSAX.getAttributes(attributes));
            return;
        }
        this.packets.add(new FFprobePacket(FFprobeCodecType.fromString(FFprobeResultSAX.getAttrValue(attributes, "codec_type")), FFprobeResultSAX.getAttrIntValue(attributes, "stream_index"), FFprobeResultSAX.getAttrLongValue(attributes, "pts"), FFprobeResultSAX.getAttrFloatValue(attributes, "pts_time"), FFprobeResultSAX.getAttrLongValue(attributes, "dts"), FFprobeResultSAX.getAttrFloatValue(attributes, "dts_time"), FFprobeResultSAX.getAttrIntValue(attributes, "duration"), FFprobeResultSAX.getAttrFloatValue(attributes, "duration_time"), FFprobeResultSAX.getAttrIntValue(attributes, "size"), FFprobeResultSAX.getAttrLongValue(attributes, "pos"), FFprobeResultSAX.getAttrValue(attributes, "flags")));
    }

    private void onFrame(Attributes attributes) {
        if (attributes.getLength() < 13) {
            log.error("Invalid <frame>, expect at least 13 attributes, get {}: {}", (Object)attributes.getLength(), FFprobeResultSAX.getAttributes(attributes));
            return;
        }
        FFprobeCodecType mediaType = FFprobeCodecType.fromString(FFprobeResultSAX.getAttrValue(attributes, "media_type"));
        FFprobeBaseFrame baseFrame = new FFprobeBaseFrame(mediaType, FFprobeResultSAX.getAttrIntValue(attributes, "stream_index"), FFprobeResultSAX.getAttrBooleanValue(attributes, "key_frame"), FFprobeResultSAX.getAttrLongValue(attributes, "pts"), FFprobeResultSAX.getAttrFloatValue(attributes, "pts_time"), FFprobeResultSAX.getAttrLongValue(attributes, "pkt_dts"), FFprobeResultSAX.getAttrFloatValue(attributes, "pkt_dts_time"), FFprobeResultSAX.getAttrLongValue(attributes, "best_effort_timestamp"), FFprobeResultSAX.getAttrFloatValue(attributes, "best_effort_timestamp_time"), FFprobeResultSAX.getAttrIntValue(attributes, "pkt_duration"), FFprobeResultSAX.getAttrFloatValue(attributes, "pkt_duration_time"), FFprobeResultSAX.getAttrLongValue(attributes, "pkt_pos"), FFprobeResultSAX.getAttrIntValue(attributes, "pkt_size"));
        if (mediaType == FFprobeCodecType.VIDEO) {
            this.onFrameVideo(attributes, baseFrame);
        } else if (mediaType == FFprobeCodecType.AUDIO) {
            this.onFrameAudio(attributes, baseFrame);
        } else {
            log.warn("Can't manage this frame type: {}, {}", (Object)mediaType, FFprobeResultSAX.getAttributes(attributes));
        }
    }

    private void onFrameVideo(Attributes attributes, FFprobeBaseFrame baseFrame) {
        if (attributes.getLength() != 27) {
            log.error("Invalid <frame media_type=\"video\">, expect 27 attributes, get {}: {}", (Object)attributes.getLength(), FFprobeResultSAX.getAttributes(attributes));
            return;
        }
        FFprobePictType pictType = Optional.ofNullable(FFprobePictType.valueOf(attributes.getValue("pict_type"))).orElse(FFprobePictType.UNKNOWN);
        FFprobeVideoFrame frame = new FFprobeVideoFrame(baseFrame, pictType, "1".equals(attributes.getValue("repeat_pict")));
        this.videoFrames.add(frame);
        FFprobeVideoFrameConst currentVideoConst = new FFprobeVideoFrameConst(frame, FFprobeResultSAX.getAttrIntValue(attributes, "width"), FFprobeResultSAX.getAttrIntValue(attributes, "height"), FFprobeResultSAX.getAttrValue(attributes, "pix_fmt"), FFprobeResultSAX.getAttrValue(attributes, "sample_aspect_ratio"), FFprobeResultSAX.getAttrIntValue(attributes, "coded_picture_number"), FFprobeResultSAX.getAttrIntValue(attributes, "display_picture_number"), FFprobeResultSAX.getAttrBooleanValue(attributes, "interlaced_frame"), FFprobeResultSAX.getAttrBooleanValue(attributes, "top_field_first"), FFprobeResultSAX.getAttrValue(attributes, "color_range"), FFprobeResultSAX.getAttrValue(attributes, "color_space"), FFprobeResultSAX.getAttrValue(attributes, "color_primaries"), FFprobeResultSAX.getAttrValue(attributes, "color_transfer"));
        if (this.videoConst == null) {
            this.videoConst = currentVideoConst;
        } else if (!this.videoConst.valuesEquals(currentVideoConst)) {
            this.olderVideoConsts.add(this.videoConst);
            this.videoConst = currentVideoConst;
        }
    }

    private void onFrameAudio(Attributes attributes, FFprobeBaseFrame baseFrame) {
        if (attributes.getLength() != 17) {
            log.error("Invalid <frame media_type=\"audio\">, expect 17 attributes, get {}: {}", (Object)attributes.getLength(), FFprobeResultSAX.getAttributes(attributes));
            return;
        }
        FFprobeAudioFrame frame = new FFprobeAudioFrame(baseFrame, FFprobeResultSAX.getAttrIntValue(attributes, "nb_samples"));
        this.audioFrames.add(frame);
        FFprobeAudioFrameConst currentAudioConst = new FFprobeAudioFrameConst(frame, FFprobeResultSAX.getAttrValue(attributes, "sample_fmt"), FFprobeResultSAX.getAttrIntValue(attributes, "channels"), ChannelLayout.parse(FFprobeResultSAX.getAttrValue(attributes, "channel_layout")));
        if (this.audioConst == null) {
            this.audioConst = currentAudioConst;
        } else if (!this.audioConst.valuesEquals(currentAudioConst)) {
            this.olderAudioConsts.add(this.audioConst);
            this.audioConst = currentAudioConst;
        }
    }

    public ContainerAnalyserResult getResult(ContainerAnalyserSession session) {
        return new ContainerAnalyserResult(session, Collections.unmodifiableList(this.packets), Collections.unmodifiableList(this.audioFrames), Collections.unmodifiableList(this.videoFrames), this.videoConst, this.audioConst, Collections.unmodifiableList(this.olderVideoConsts), Collections.unmodifiableList(this.olderAudioConsts));
    }

    private static String getAttrValue(Attributes attributes, String keyName) {
        String value = attributes.getValue(keyName);
        if (value == null) {
            log.error("Can't get attribute {}", (Object)keyName);
            return "";
        }
        return value;
    }

    private static boolean getAttrBooleanValue(Attributes attributes, String keyName) {
        return FFprobeResultSAX.getAttrValue(attributes, keyName).equals("1");
    }

    private static int getAttrIntValue(Attributes attributes, String keyName) {
        String value = FFprobeResultSAX.getAttrValue(attributes, keyName);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.error(CAN_T_EXTRACT_NUMBER_FROM, (Object)keyName, (Object)value);
            return -1;
        }
    }

    private static long getAttrLongValue(Attributes attributes, String keyName) {
        String value = FFprobeResultSAX.getAttrValue(attributes, keyName);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.error(CAN_T_EXTRACT_NUMBER_FROM, (Object)keyName, (Object)value);
            return -1L;
        }
    }

    private static float getAttrFloatValue(Attributes attributes, String keyName) {
        String value = FFprobeResultSAX.getAttrValue(attributes, keyName);
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException e) {
            log.error(CAN_T_EXTRACT_NUMBER_FROM, (Object)keyName, (Object)value);
            return -1.0f;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        log.warn("SAX error (during {})", (Object)this.processSource, (Object)e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        log.warn("SAX error (during {})", (Object)this.processSource, (Object)e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        log.warn("SAX warning (during {})", (Object)this.processSource, (Object)e);
    }

    static {
        try {
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new InternalError("Can't load SAX parser", e);
        }
    }
}

