/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher.about;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FFAboutVersion {
    private static final String FFPLAY_VERSION = "ffplay version ";
    private static final String FFPROBE_VERSION = "ffprobe version ";
    private static final String FFMPEG_VERSION = "ffmpeg version ";
    private static final String HEADER_CONFIGURATION = "configuration:";
    private static final Logger log = LogManager.getLogger();
    public final String headerVersion;
    public final String builtWith;
    public final Set<String> configuration;
    public final String rawConfiguration;
    public final String libavutilVersion;
    public final String libavcodecVersion;
    public final String libavformatVersion;
    public final String libavdeviceVersion;
    public final String libavfilterVersion;
    public final String libswscaleVersion;
    public final String libswresampleVersion;
    public final String libpostprocVersion;

    FFAboutVersion(List<String> processResult) {
        this.headerVersion = processResult.stream().filter(l -> l.startsWith(FFMPEG_VERSION) || l.startsWith(FFPROBE_VERSION) || l.startsWith(FFPLAY_VERSION)).findFirst().map(l -> {
            if (l.startsWith(FFMPEG_VERSION)) {
                return l.substring(FFMPEG_VERSION.length());
            }
            if (l.startsWith(FFPROBE_VERSION)) {
                return l.substring(FFPROBE_VERSION.length());
            }
            if (l.startsWith(FFPLAY_VERSION)) {
                return l.substring(FFPLAY_VERSION.length());
            }
            return null;
        }).filter(Objects::nonNull).map(String::trim).orElse("?");
        this.builtWith = processResult.stream().filter(l -> l.startsWith("built with ")).findFirst().orElse("built with ?").substring("built with ".length()).trim();
        this.rawConfiguration = processResult.stream().filter(l -> l.startsWith(HEADER_CONFIGURATION)).findFirst().orElse(HEADER_CONFIGURATION).substring(HEADER_CONFIGURATION.length()).trim();
        this.configuration = Collections.unmodifiableSet(Arrays.stream(this.rawConfiguration.split(" ")).map(c -> {
            if (c.startsWith("--enable-")) {
                return c.substring("--enable-".length()).trim();
            }
            if (c.startsWith("--as=")) {
                return c.substring("--as=".length()).trim();
            }
            return c.trim();
        }).distinct().collect(Collectors.toSet()));
        log.debug(() -> "\"" + this.rawConfiguration + "\" <-> configuration: " + this.configuration);
        this.libavutilVersion = FFAboutVersion.extractLibavVersion("libavutil", processResult);
        this.libavcodecVersion = FFAboutVersion.extractLibavVersion("libavcodec", processResult);
        this.libavformatVersion = FFAboutVersion.extractLibavVersion("libavformat", processResult);
        this.libavdeviceVersion = FFAboutVersion.extractLibavVersion("libavdevice", processResult);
        this.libavfilterVersion = FFAboutVersion.extractLibavVersion("libavfilter", processResult);
        this.libswscaleVersion = FFAboutVersion.extractLibavVersion("libswscale", processResult);
        this.libswresampleVersion = FFAboutVersion.extractLibavVersion("libswresample", processResult);
        this.libpostprocVersion = FFAboutVersion.extractLibavVersion("libpostproc", processResult);
    }

    public String toString() {
        return this.headerVersion;
    }

    private static String extractLibavVersion(String key, List<String> lines) {
        String line = lines.stream().filter(l -> l.startsWith(key)).findFirst().orElse(key + "      ?.?.?");
        return line.substring(key.length()).trim();
    }
}

