/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.fflauncher;

import java.io.File;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.ffmpeg.ffprobe.StreamType;
import tv.hd3g.fflauncher.FFbase;
import tv.hd3g.fflauncher.HardwareProcessTraits;
import tv.hd3g.fflauncher.InputGeneratorsTraits;
import tv.hd3g.fflauncher.VideoOutputTrait;
import tv.hd3g.fflauncher.progress.ProgressCallback;
import tv.hd3g.fflauncher.progress.ProgressListener;
import tv.hd3g.fflauncher.progress.ProgressListenerSession;
import tv.hd3g.ffprobejaxb.FFprobeJAXB;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class FFmpeg
extends FFbase
implements InputGeneratorsTraits,
HardwareProcessTraits,
VideoOutputTrait {
    public static final Duration statsPeriod = Duration.ofSeconds(1L);
    private int deviceIdToUse = -1;
    protected ProgressListener progressListener;
    protected ProgressCallback progressCallback;

    public FFmpeg(String execName, Parameters parameters) {
        super(execName, parameters);
    }

    public FFmpeg setNostats() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-nostats"}), new String[]{"-nostats"});
        return this;
    }

    public FFmpeg setNoVideo() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-vn"}), new String[]{"-vn"});
        return this;
    }

    public FFmpeg setNoAudio() {
        this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-an"}), new String[]{"-an"});
        return this;
    }

    public FFmpeg addSimpleOutputDestination(String destinationName, String destinationContainer) {
        Objects.requireNonNull(destinationName, "\"destinationName\" can't to be null");
        Objects.requireNonNull(destinationContainer, "\"destinationContainer\" can't to be null");
        String varname = this.getInternalParameters().tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationName, varname, "-f", destinationContainer);
        return this;
    }

    public FFmpeg addSimpleOutputDestination(File destinationFile, String destinationContainer) {
        Objects.requireNonNull(destinationFile, "\"destinationFile\" can't to be null");
        Objects.requireNonNull(destinationContainer, "\"destinationContainer\" can't to be null");
        String varname = this.getInternalParameters().tagVar("OUT_AUTOMATIC_" + this.outputExpectedDestinations.size());
        this.addOutputDestination(destinationFile, varname, "-f", destinationContainer);
        return this;
    }

    public FFmpeg addFastStartMovMp4File() {
        this.getInternalParameters().addBulkParameters("-movflags faststart");
        return this;
    }

    @Deprecated(forRemoval=true, since="9.1.0")
    public static Optional<StreamType> getFirstVideoStream(FFprobeJAXB analysingResult) {
        return analysingResult.getFirstVideoStream();
    }

    public FFmpeg setDeviceIdToUse(int deviceIdToUse) {
        this.deviceIdToUse = deviceIdToUse;
        return this;
    }

    @Override
    public int getDeviceIdToUse() {
        return this.deviceIdToUse;
    }

    public FFmpeg addAudioCodecName(String codecName, int outputAudioStreamIndex) {
        if (outputAudioStreamIndex > -1) {
            this.getInternalParameters().addParameters(new String[]{"-c:a:" + outputAudioStreamIndex, codecName});
        } else {
            this.getInternalParameters().addParameters(new String[]{"-c:a", codecName});
        }
        return this;
    }

    public FFmpeg addMap(int sourceIndex, int streamIndexInSource) {
        this.getInternalParameters().addParameters(new String[]{"-map", sourceIndex + ":" + streamIndexInSource});
        return this;
    }

    public FFmpeg setProgressListener(ProgressListener progressListener, ProgressCallback progressCallback) {
        this.progressListener = Objects.requireNonNull(progressListener, "\"progressListener\" can't to be null");
        this.progressCallback = Objects.requireNonNull(progressCallback, "\"progressCallback\" can't to be null");
        return this;
    }

    public FFmpeg resetProgressListener() {
        this.progressListener = null;
        this.progressCallback = null;
        return this;
    }

    public Consumer<ProcesslauncherBuilder> beforeExecute() {
        if (this.progressListener != null && this.progressCallback != null) {
            if (this.parameters.hasParameters(new String[]{"-progress"})) {
                throw new IllegalArgumentException("ffmpeg command line as already \"-progress\" option: " + this.parameters);
            }
            this.parameters.ifHasNotParameter(() -> this.parameters.prependParameters(new String[]{"-stats_period", String.valueOf(statsPeriod.toSeconds())}), new String[]{"-stats_period"});
            ProgressListenerSession session = this.progressListener.createSession(this.progressCallback, statsPeriod);
            int port = session.start();
            this.parameters.prependParameters(new String[]{"-progress", "tcp://127.0.0.1:" + port});
            return builder -> {
                super.beforeExecute().accept(builder);
                builder.addExecutionCallbacker(processlauncherLifecycle -> session.manualClose());
            };
        }
        return super.beforeExecute();
    }
}

