/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.csvkit;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSVKit {
    private static Logger log = LogManager.getLogger();
    protected final CSVParserBuilder csvParserBuilder;
    protected final int skipLines;

    public CSVKit(CSVParserBuilder csvParserBuilder, int skipLines) {
        this.csvParserBuilder = csvParserBuilder;
        this.skipLines = skipLines;
    }

    public static CSVKit createFrenchFlavor(int skipLines) {
        CSVParserBuilder parser = new CSVParserBuilder().withSeparator(';').withQuoteChar('\"');
        return new CSVKit(parser, skipLines);
    }

    protected CSVReaderBuilder createCSVReaderBuilder(Reader reader) {
        return new CSVReaderBuilder(reader).withCSVParser((ICSVParser)this.csvParserBuilder.build()).withSkipLines(this.skipLines);
    }

    public <T> void importCSV(byte[] rawSource, Charset sourceCharset, Predicate<String[]> rowValidator, Function<String[], T> transform, LinkedBlockingQueue<T> result) {
        try (StringReader reader = new StringReader(new String(rawSource, sourceCharset));
             CSVReader csvReader = this.createCSVReaderBuilder(reader).build();){
            String[] nextLine;
            while ((nextLine = csvReader.readNext()) != null) {
                if (!rowValidator.test(nextLine)) continue;
                result.add(transform.apply(nextLine));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't read CSV", e);
        }
        catch (CsvValidationException e) {
            throw new UncheckedIOException(new IOException("Can't parse CSV", e));
        }
    }

    public <T> void importAllCSV(Map<String, Supplier<byte[]>> rawSourcesBySourceNames, Charset sourceCharset, Predicate<String[]> rowValidator, Function<String[], T> transform, LinkedBlockingQueue<T> result) {
        rawSourcesBySourceNames.forEach((name, source) -> {
            log.info("Start load CSV from \"{}\"...", name);
            this.importCSV((byte[])source.get(), sourceCharset, rowValidator, transform, result);
        });
    }

    public static <T, R> Map<String, R> groupingById(Stream<T> values, Function<? super T, String> idClassifier, Function<List<T>, R> transform) {
        return values.collect(Collectors.groupingBy(idClassifier, Collectors.collectingAndThen(Collectors.toUnmodifiableList(), transform)));
    }

    public static <L, R, C> Map<String, C> aggregateById(Map<String, L> left, Map<String, R> right, BiFunction<L, R, C> transform, BiConsumer<String, R> lostLeft, BiConsumer<String, L> lostRight) {
        left.keySet().stream().filter(Predicate.not(right::containsKey)).forEach(id -> lostRight.accept((String)id, (Object)left.get(id)));
        right.keySet().stream().filter(Predicate.not(left::containsKey)).forEach(id -> lostLeft.accept((String)id, (Object)right.get(id)));
        return left.keySet().stream().filter(right::containsKey).collect(Collectors.toUnmodifiableMap(id -> id, id -> transform.apply(left.get(id), right.get(id))));
    }
}

