/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.commons.version.mod;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import tv.hd3g.commons.version.EnvironmentVersion;

@Configuration
public class EnvVersionConfigurer {
    private static final Logger log = LogManager.getLogger();

    @Bean
    EnvironmentVersion getEnvVersion(ApplicationContext context) {
        String appVersion = context.getBeansWithAnnotation(SpringBootApplication.class).entrySet().stream().findFirst().map(Map.Entry::getValue).map(Object::getClass).map(Class::getPackage).map(Package::getImplementationVersion).flatMap(Optional::ofNullable).or(EnvVersionConfigurer::getPomVersion).or(EnvVersionConfigurer::getMavenVersion).orElse(null);
        log.debug("appVersion: \"{}\"", (Object)appVersion);
        return EnvironmentVersion.makeEnvironmentVersion((String)appVersion, (String)EnvVersionConfigurer.getProdlibVersion(), (String)("Spring Boot v" + SpringBootVersion.getVersion()));
    }

    private static Optional<String> getPomVersion() {
        File xmlFile = new File("pom.xml");
        if (!xmlFile.exists()) {
            return Optional.empty();
        }
        try {
            log.debug("Load {} to extract <version />", (Object)xmlFile.getAbsolutePath());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setExpandEntityReferences(false);
            Document doc = factory.newDocumentBuilder().parse(xmlFile);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/project/version";
            String result = (String)xPath.compile("/project/version").evaluate(doc, XPathConstants.STRING);
            log.debug("Result: \"{}\"", (Object)result);
            return Optional.ofNullable(result).stream().map(String::trim).filter(Predicate.not(String::isEmpty)).findFirst();
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            log.warn("Error during pom.xml version extraction", (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<String> getMavenVersion() {
        String mvnCmdLine = "mvn help:evaluate -Dexpression=project.version -q -DforceStdout";
        try {
            log.debug("Run {}", (Object)"mvn help:evaluate -Dexpression=project.version -q -DforceStdout");
            Process r = System.getProperty("os.name", "").toLowerCase().contains("windows") ? Runtime.getRuntime().exec("cmd /c mvn help:evaluate -Dexpression=project.version -q -DforceStdout") : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "mvn help:evaluate -Dexpression=project.version -q -DforceStdout"});
            while (r.isAlive()) {
                Thread.onSpinWait();
            }
            if (r.exitValue() != 0) {
                log.warn("Can't run maven: {}", new Supplier[]{() -> r.errorReader().lines().collect(Collectors.joining("; "))});
                return Optional.empty();
            }
            byte[] buffer = new byte[256];
            int size = r.getInputStream().read(buffer);
            if (size < 1) {
                log.debug("Result: (no stdout)");
                return Optional.empty();
            }
            String result = new String(buffer, 0, size).trim();
            log.debug("Result: \"{}\"", (Object)result);
            return Stream.of(result).filter(Predicate.not(String::isEmpty)).findFirst();
        }
        catch (IOException e) {
            log.warn("Error during mvn run version extraction", (Throwable)e);
            return Optional.empty();
        }
    }

    private static String getProdlibVersion() {
        String fileName = "prodlib-version.txt";
        try {
            InputStream is = EnvVersionConfigurer.class.getClassLoader().getResourceAsStream("prodlib-version.txt");
            if (is == null) {
                log.warn("Can't found \"{}\" from resources", (Object)"prodlib-version.txt");
                return null;
            }
            byte[] buffer = new byte[256];
            int size = is.read(buffer);
            if (size < 1) {
                log.debug("{} resource file is empty!", (Object)"prodlib-version.txt");
                return null;
            }
            String result = new String(buffer, 0, size).trim();
            if (result.isEmpty()) {
                log.debug("{} resource file is full of spaces!", (Object)"prodlib-version.txt");
                return null;
            }
            log.debug("Prodlib version: \"{}\"", (Object)result);
            return result;
        }
        catch (IOException e) {
            log.warn("Can't open \"{}\" from resources", (Object)"prodlib-version.txt");
            return null;
        }
    }
}

