/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.utility;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public enum ControllerType {
    CLASSIC,
    REST;


    public static ControllerType getFromClass(Class<?> referer) {
        if (((RestController[])referer.getAnnotationsByType(RestController.class)).length > 0) {
            return REST;
        }
        if (((Controller[])referer.getAnnotationsByType(Controller.class)).length > 0) {
            return CLASSIC;
        }
        String annotations = Stream.of(referer.getAnnotations()).map(a -> "@" + a.annotationType().getSimpleName()).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Can't extract the controller type from: " + referer.getName() + " {" + annotations + "}");
    }
}

