/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.StringUtils;
import org.owasp.encoder.Encode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.Totpbackupcode;
import tv.hd3g.authkit.mod.entity.User;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.repository.CredentialRepository;
import tv.hd3g.authkit.mod.repository.TotpbackupcodeRepository;
import tv.hd3g.authkit.mod.service.CipherService;
import tv.hd3g.authkit.mod.service.TOTPService;

@Service
public class TOTPServiceImpl
implements TOTPService {
    public static final Base32 base32 = new Base32(false);
    @Autowired
    private CipherService cipherService;
    @Autowired
    private CredentialRepository credentialRepository;
    @Autowired
    private TotpbackupcodeRepository totpbackupcodeRepository;
    @Value(value="${authkit.backupCodeQuantity:6}")
    private int backupCodeQuantity;
    @Value(value="${authkit.totpTimeStepSeconds:30}")
    private int timeStepSeconds;
    @Value(value="${authkit.totpWindowMillis:5000}")
    private long windowMillis;

    @Override
    public String makeSecret() {
        byte[] secret = new byte[64];
        Random random = this.cipherService.getSecureRandom();
        random.nextBytes(secret);
        return base32.encodeAsString(secret);
    }

    @Override
    public URI makeURI(String secret, User user, String totpDomain) {
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, "Can't found Credential for user " + user.getUuid());
        String login = credential.getLogin();
        try {
            return new URI("otpauth://totp/" + login + "@" + Encode.forJavaScript((String)totpDomain) + "?secret=" + secret);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI parameters", e);
        }
    }

    @Override
    public String makeQRCode(URI url) {
        try {
            int size = 400;
            BitMatrix bitMatrix = new QRCodeWriter().encode(url.toString(), BarcodeFormat.QR_CODE, 400, 400);
            ByteArrayOutputStream byteArrayQRCodePNG = new ByteArrayOutputStream(4095);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayQRCodePNG);
            return Base64.getEncoder().encodeToString(byteArrayQRCodePNG.toByteArray());
        }
        catch (WriterException | IOException e) {
            throw new IllegalArgumentException("Problem with QRcode generation", e);
        }
    }

    @Override
    public List<String> makeBackupCodes() {
        return this.cipherService.getSecureRandom().ints(this.backupCodeQuantity, 0, 1000000).mapToObj(i -> StringUtils.leftPad((String)String.valueOf(i), (int)6, (String)"0")).toList();
    }

    @Override
    @Transactional(readOnly=false)
    public void setupTOTP(String base32Secret, Collection<String> backupCodes, String userUUID) {
        byte[] secret = base32.decode(base32Secret);
        Credential credential = this.credentialRepository.getByUserUUID(userUUID);
        credential.getTotpBackupCodes().clear();
        Set newCodes = backupCodes.stream().map(code -> new Totpbackupcode(credential, (String)code)).collect(Collectors.toUnmodifiableSet());
        credential.getTotpBackupCodes().addAll(newCodes);
        credential.setTotpkey(this.cipherService.cipherFromData(secret));
    }

    @Override
    public boolean isCodeIsValid(byte[] secret, String code) {
        try {
            long now = System.currentTimeMillis();
            String actualCode = TOTPServiceImpl.makeCodeAtTime(secret, now, this.timeStepSeconds);
            if (actualCode.equals(code)) {
                return true;
            }
            String previousCode = TOTPServiceImpl.makeCodeAtTime(secret, now - this.windowMillis, this.timeStepSeconds);
            if (previousCode.equals(code)) {
                return true;
            }
            String nextCode = TOTPServiceImpl.makeCodeAtTime(secret, now + this.windowMillis, this.timeStepSeconds);
            if (nextCode.equals(code)) {
                return true;
            }
        }
        catch (GeneralSecurityException e) {
            throw new AuthKitException(500, "Can't manage cipher tools");
        }
        return false;
    }

    @Override
    @Transactional(readOnly=false)
    public void checkCode(Credential credential, String stringCode) throws UserCantLoginException.BadTOTPCodeCantLoginException {
        byte[] secret = this.cipherService.unCipherToData(credential.getTotpkey());
        if (!this.isCodeIsValid(secret, stringCode)) {
            Totpbackupcode bcpCode = this.totpbackupcodeRepository.getByCredential(credential).stream().filter(bcp -> bcp.getCode().equals(stringCode)).findFirst().orElseThrow(UserCantLoginException.BadTOTPCodeCantLoginException::new);
            this.totpbackupcodeRepository.delete(bcpCode);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void removeTOTP(Credential credential) {
        credential.setTotpkey(null);
        this.credentialRepository.save(credential);
        this.totpbackupcodeRepository.getByCredential(credential).forEach(bcp -> this.totpbackupcodeRepository.delete(bcp));
    }

    public static String makeCodeAtTime(byte[] secret, long timeMillis, int timeStepSeconds) throws GeneralSecurityException {
        byte[] data = new byte[8];
        long value = timeMillis / 1000L / (long)timeStepSeconds;
        int i = 7;
        while (value > 0L) {
            data[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        SecretKeySpec signKey = new SecretKeySpec(secret, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = offset; i2 < offset + 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return StringUtils.leftPad((String)String.valueOf((int)(truncatedHash %= 1000000L)), (int)6, (String)"0");
    }
}

