/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.service.CookieService;

@Service
public class CookieServiceImpl
implements CookieService {
    @Autowired
    private ServletContext servletContext;
    @Value(value="${authkit.cookie.domain:}")
    private String domain;
    @Value(value="${authkit.cookie.path:#{servletContext.contextPath}}")
    private String path;
    @Value(value="${authkit.cookie.ttlRedirect:1h}")
    private Duration redirectTTL;

    @PostConstruct
    public void init() {
        if (this.domain == null || this.domain.isEmpty()) {
            try {
                this.domain = this.servletContext.getVirtualServerName();
            }
            catch (UnsupportedOperationException e0) {
                try {
                    this.domain = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e1) {
                    throw new UncheckedIOException(e1);
                }
            }
        }
    }

    @Override
    public Cookie createLogonCookie(String userSessionToken, Duration ttl) {
        Cookie cookie = new Cookie("SESSIONBEARER", userSessionToken);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        cookie.setMaxAge((int)ttl.toSeconds());
        return cookie;
    }

    @Override
    public Cookie deleteLogonCookie() {
        Cookie cookie = new Cookie("SESSIONBEARER", null);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        return cookie;
    }

    @Override
    public String getLogonCookiePayload(HttpServletRequest request) {
        return this.getCookiePayload(request, "SESSIONBEARER");
    }

    @Override
    public Cookie createRedirectAfterLoginCookie(String redirectToPath) {
        Cookie cookie = new Cookie("REDIRECTAFTERLOGIN", redirectToPath);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        cookie.setMaxAge((int)this.redirectTTL.toSeconds());
        return cookie;
    }

    @Override
    public Cookie deleteRedirectAfterLoginCookie() {
        Cookie cookie = new Cookie("REDIRECTAFTERLOGIN", null);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setDomain(this.domain);
        cookie.setPath(this.path);
        return cookie;
    }

    private String getCookiePayload(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        return Stream.of(cookies).filter(cookie -> name.equals(cookie.getName())).findFirst().map(Cookie::getValue).orElse(null);
    }

    @Override
    public String getRedirectAfterLoginCookiePayload(HttpServletRequest request) {
        return this.getCookiePayload(request, "REDIRECTAFTERLOGIN");
    }
}

