/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import tv.hd3g.authkit.mod.component.SqlFileResourceHelper;
import tv.hd3g.authkit.mod.dto.ressource.UserDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.User;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.repository.UserDao;

@Repository
public class UserDaoImpl
implements UserDao {
    private static Logger log = LogManager.getLogger();
    private static final String HQL_CLIENT_ADDR = "clientAddr";
    private static final String HQL_USER_UUID = "userUUID";
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SqlFileResourceHelper sqlFileResourceHelper;

    @Override
    @Transactional
    public UUID addUserCredential(String userLogin, byte[] cipherHashedPassword, String realm) {
        UUID uuid = UUID.randomUUID();
        User user = new User(uuid);
        Credential credential = new Credential(user, userLogin, cipherHashedPassword, realm, true, false);
        this.entityManager.persist((Object)user);
        this.entityManager.persist((Object)credential);
        return uuid;
    }

    @Override
    @Transactional
    public UUID addLDAPUserCredential(String userLogin, String ldapDomain, String realm) {
        UUID uuid = UUID.randomUUID();
        User user = new User(uuid);
        Credential credential = new Credential(user, userLogin, ldapDomain, realm, true);
        this.entityManager.persist((Object)user);
        this.entityManager.persist((Object)credential);
        return uuid;
    }

    @Override
    @Transactional
    public void deleteUser(UUID userUUID) {
        Optional oUserToDelete = this.entityManager.createQuery("SELECT u FROM User u WHERE u.uuid = :userUUID", User.class).setParameter(HQL_USER_UUID, (Object)userUUID.toString()).getResultStream().findFirst();
        User userToDelete = (User)oUserToDelete.orElseThrow(() -> new AuthKitException("Can't found user with UUID " + userUUID));
        this.entityManager.remove((Object)userToDelete);
    }

    @Override
    @Transactional
    public Optional<UserDto> getUserByUUID(UUID userUUID) {
        String sql = this.sqlFileResourceHelper.getSql("getuser.sql");
        return this.entityManager.createQuery(sql, UserDto.class).setParameter(HQL_USER_UUID, (Object)userUUID.toString()).getResultStream().findFirst();
    }

    @Override
    @Transactional
    public List<UserDto> getUserList(int pos, int size) {
        String sql = this.sqlFileResourceHelper.getSql("listuser.sql");
        return this.entityManager.createQuery(sql, UserDto.class).setFirstResult(pos).setMaxResults(size).getResultList();
    }

    @Override
    @Transactional
    public List<String> getRightsForUser(String userUUID, String clientAddr) {
        String sql = this.sqlFileResourceHelper.getSql("getrightsforuser.sql");
        return this.entityManager.createQuery(sql, String.class).setParameter(HQL_USER_UUID, (Object)userUUID).setParameter(HQL_CLIENT_ADDR, (Object)clientAddr).getResultList();
    }

    @Override
    @Transactional
    public List<String> getContextRightsForUser(String userUUID, String clientAddr, String rightName) {
        String sql = this.sqlFileResourceHelper.getSql("getcontextrightsforuser.sql");
        return this.entityManager.createQuery(sql, String.class).setParameter(HQL_USER_UUID, (Object)userUUID).setParameter(HQL_CLIENT_ADDR, (Object)clientAddr).setParameter("rightName", (Object)rightName).getResultList();
    }

    @Override
    public boolean haveRightsForUserWithOnlyIP(String userUUID, String clientAddr) {
        String sql = this.sqlFileResourceHelper.getSql("countrightsforuserwithiponly.sql");
        return (Long)this.entityManager.createQuery(sql, Long.class).setParameter(HQL_USER_UUID, (Object)userUUID).setParameter(HQL_CLIENT_ADDR, (Object)clientAddr).getSingleResult() > 0L;
    }

    @Override
    @Transactional
    public void deleteExternalUserCredential(String userName, String domain, String realm) {
        try {
            String sql0 = "SELECT c FROM Credential c WHERE c.login = :userName AND c.ldapdomain = :domain AND c.realm = :realm";
            Credential credential = (Credential)this.entityManager.createQuery("SELECT c FROM Credential c WHERE c.login = :userName AND c.ldapdomain = :domain AND c.realm = :realm", Credential.class).setParameter("userName", (Object)userName).setParameter("domain", (Object)domain).setParameter("realm", (Object)realm).getSingleResult();
            String sql1 = "DELETE Totpbackupcode t WHERE t.credential = :credential";
            this.entityManager.createQuery("DELETE Totpbackupcode t WHERE t.credential = :credential").setParameter("credential", (Object)credential).executeUpdate();
            this.entityManager.remove((Object)credential.getUser());
            this.entityManager.remove((Object)credential);
        }
        catch (NoResultException e) {
            log.debug("Can't delete a non-found object {}@{}", (Object)userName, (Object)domain, (Object)e);
        }
    }

    @Override
    @Transactional
    public boolean deleteGroup(String groupName) {
        String sql = "DELETE Group g WHERE g.name = :groupName";
        return this.entityManager.createQuery("DELETE Group g WHERE g.name = :groupName").setParameter("groupName", (Object)groupName).executeUpdate() == 1;
    }
}

